# -*- coding: utf-8 -*-
# Copyright 2014 Objectif Libre
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#
# @author: Stéphane Albert
#
from cloudkitty import transformer


class CeilometerTransformer(transformer.BaseTransformer):
    compute_map = {
        'name': ['display_name'],
        'flavor': ['flavor.name', 'instance_type'],
        'vcpus': ['vcpus'],
        'memory': ['memory_mb'],
        'image_id': ['image.id', 'image_meta.base_image_ref'],
        'availability_zone': [
            'availability_zone',
            'OS-EXT-AZ.availability_zone'],
    }
    volume_map = {
        'volume_id': ['volume_id'],
        'name': ['display_name'],
        'availability_zone': ['availability_zone'],
        'size': ['size'],
    }
    metadata_item = 'metadata'

    def _strip_compute(self, data):
        res_data = self.generic_strip('compute', data)
        res_data['instance_id'] = data.resource_id
        res_data['project_id'] = data.project_id
        res_data['user_id'] = data.user_id
        res_data['metadata'] = {}
        for field in data.metadata:
            if field.startswith('user_metadata'):
                res_data['metadata'][field[14:]] = data.metadata[field]
        return res_data

    def _strip_volume(self, data):
        res_data = self.generic_strip('volume', data)
        res_data['user_id'] = data.user_id
        res_data['project_id'] = data.project_id
        return res_data
