/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenRuntimeException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;

public class StringFunction
implements Function {
    private static NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);

    public Object call(Context context, List args) throws FunctionCallException {
        int size = args.size();
        if (size == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (size == 1) {
            return StringFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() requires one argument.");
    }

    public static String evaluate(Object obj, Navigator nav) {
        try {
            if (obj == null) {
                return "";
            }
            if (nav != null && nav.isText(obj)) {
                return nav.getTextStringValue(obj);
            }
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return "";
                }
                obj = list.get(0);
            }
            if (nav != null && (nav.isElement(obj) || nav.isDocument(obj))) {
                Iterator descendantAxisIterator = nav.getDescendantAxisIterator(obj);
                StringBuffer sb = new StringBuffer();
                while (descendantAxisIterator.hasNext()) {
                    Object descendant = descendantAxisIterator.next();
                    if (!nav.isText(descendant)) continue;
                    sb.append(nav.getTextStringValue(descendant));
                }
                return sb.toString();
            }
            if (nav != null && nav.isAttribute(obj)) {
                return nav.getAttributeStringValue(obj);
            }
            if (nav != null && nav.isText(obj)) {
                return nav.getTextStringValue(obj);
            }
            if (nav != null && nav.isProcessingInstruction(obj)) {
                return nav.getProcessingInstructionData(obj);
            }
            if (nav != null && nav.isComment(obj)) {
                return nav.getCommentStringValue(obj);
            }
            if (nav != null && nav.isNamespace(obj)) {
                return nav.getNamespaceStringValue(obj);
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Boolean) {
                return StringFunction.stringValue((Boolean)obj);
            }
            if (obj instanceof Number) {
                return StringFunction.stringValue(((Number)obj).doubleValue());
            }
            return "";
        }
        catch (UnsupportedAxisException e) {
            throw new JaxenRuntimeException(e);
        }
    }

    public static String stringValue(double value) {
        return format.format(value);
    }

    public static String stringValue(boolean bool) {
        return bool ? "true" : "false";
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(32);
    }
}

