/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class ANTLR3
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target = null;
    private File outputDirectory = null;
    private File libDirectory = null;
    private File superGrammar;
    private boolean depend = false;
    private boolean fork;
    private String messageFormatName;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private File workingdir = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private boolean debug;
    private boolean report;
    private boolean print;
    private boolean profile;
    private boolean nfa;
    private boolean dfa;
    private boolean multiThreaded;
    private boolean nocollapse;
    private boolean noprune;
    private boolean dbgST;
    private boolean grammarTree;
    private FileUtils fileUtils;
    private String conversiontimeout;

    public ANTLR3() {
        this.commandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.commandline.setClassname("org.antlr.Tool");
        this.fileUtils = FileUtils.getFileUtils();
    }

    public void setTarget(File targetFile) {
        this.log("Setting target to: " + targetFile.toString(), 3);
        this.target = targetFile;
    }

    public void setOutputdirectory(File outputDirectoryFile) {
        this.log("Setting output directory to: " + outputDirectoryFile.toString(), 3);
        this.outputDirectory = outputDirectoryFile;
    }

    public File getOutputdirectory() {
        return this.outputDirectory;
    }

    public void setLibdirectory(File libDirectoryFile) {
        this.log("Setting lib directory to: " + libDirectoryFile.toString(), 3);
        this.libDirectory = libDirectoryFile;
    }

    public void setMessageformat(String name) {
        this.log("Setting message-format to: " + name, 3);
        this.messageFormatName = name;
    }

    public void setGlib(File superGrammarFile) {
        this.superGrammar = superGrammarFile;
    }

    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    public void setReport(boolean enable) {
        this.report = enable;
    }

    public void setPrint(boolean enable) {
        this.print = enable;
    }

    public void setProfile(boolean enable) {
        this.profile = enable;
    }

    public void setNfa(boolean enable) {
        this.nfa = enable;
    }

    public void setDfa(boolean enable) {
        this.dfa = enable;
    }

    public void setMultithreaded(boolean enable) {
        this.multiThreaded = enable;
    }

    public void setNocollapse(boolean enable) {
        this.nocollapse = enable;
    }

    public void setNoprune(boolean enable) {
        this.noprune = enable;
    }

    public void setDbgST(boolean enable) {
        this.dbgST = enable;
    }

    public void setConversiontimeout(String conversiontimeoutString) {
        this.log("Setting conversiontimeout to: " + conversiontimeoutString, 3);
        try {
            int timeout = Integer.valueOf(conversiontimeoutString);
            this.conversiontimeout = conversiontimeoutString;
        }
        catch (NumberFormatException e) {
            this.log("Option ConversionTimeOut ignored due to illegal value: '" + conversiontimeoutString + "'", 0);
        }
    }

    public void setGrammartree(boolean enable) {
        this.grammarTree = enable;
    }

    public void setDepend(boolean s) {
        this.depend = s;
    }

    public void setDiagnostic(boolean enable) {
        this.diagnostic = enable;
    }

    public void setTrace(boolean enable) {
        this.trace = enable;
    }

    public void setTraceParser(boolean enable) {
        this.traceParser = enable;
    }

    public void setTraceLexer(boolean enable) {
        this.traceLexer = enable;
    }

    public void setFork(boolean s) {
        this.fork = s;
    }

    public void setDir(File d) {
        this.workingdir = d;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        Map<String, String> variables = System.getenv();
        String antlrHome = variables.get("ANTLR_HOME");
        if (antlrHome != null) {
            this.addAntlrJarsToClasspath(antlrHome + "/lib");
        }
        this.addClasspathEntry("/antlr/ANTLRGrammarParseBehavior.class", "AntLR2");
        this.addClasspathEntry("/org/antlr/tool/ANTLRParser.class", "AntLR3");
        this.addClasspathEntry("/org/antlr/stringtemplate/StringTemplate.class", "Stringtemplate");
    }

    protected void addClasspathEntry(String resource, String msg) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found via classpath: " + f.getAbsolutePath(), 3);
            this.createClasspath().setLocation(f);
        } else {
            this.log("Couldn't find resource " + resource + " for library " + msg + " in external classpath", 3);
        }
    }

    private void addAntlrJarsToClasspath(String antlrLibDir) {
        String[] files;
        String[] includes = new String[]{"antlr-*.jar", "stringtemplate-*.jar"};
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        ds.setBasedir(new File(antlrLibDir));
        ds.setCaseSensitive(true);
        ds.scan();
        String separator = System.getProperty("file.separator");
        for (String file : files = ds.getIncludedFiles()) {
            File f = new File(antlrLibDir + separator + file);
            this.log("Found via ANTLR_HOME: " + f.getAbsolutePath(), 3);
            this.createClasspath().setLocation(f);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.dependencyCheck()) {
            this.populateAttributes();
            this.commandline.createArgument().setValue(this.target.toString());
            this.log(this.commandline.describeCommand(), 3);
            int err = 0;
            try {
                err = this.run(this.commandline.getCommandline(), (OutputStream)new LogOutputStream((Task)this, 2), (OutputStream)new LogOutputStream((Task)this, 1));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
            finally {
                try {
                    this.bos.close();
                }
                catch (IOException e) {}
            }
            if (err != 0) {
                throw new BuildException("ANTLR returned: " + err, this.getLocation());
            }
            Pattern p = Pattern.compile("error\\([0-9]+\\):");
            Matcher m = p.matcher(this.bos.toString());
            if (m.find()) {
                throw new BuildException("ANTLR signaled an error.", this.getLocation());
            }
        } else {
            try {
                this.log("All dependencies of grammar file '" + this.target.getCanonicalPath() + "' are up to date.", 3);
            }
            catch (IOException ex) {
                this.log("All dependencies of grammar file '" + this.target.toString() + "' are up to date.", 3);
            }
        }
    }

    private void populateAttributes() {
        this.commandline.createArgument().setValue("-o");
        this.commandline.createArgument().setValue(this.outputDirectory.toString());
        this.commandline.createArgument().setValue("-lib");
        this.commandline.createArgument().setValue(this.libDirectory.toString());
        if (this.superGrammar != null) {
            this.log("Option 'glib' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.diagnostic) {
            this.commandline.createArgument().setValue("-diagnostic");
        }
        if (this.depend) {
            this.log("Option 'depend' is implicitely always used by ANTLR v3. Option can safely be omitted!", 1);
        }
        if (this.trace) {
            this.log("Option 'trace' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.traceParser) {
            this.log("Option 'traceParser' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.traceLexer) {
            this.log("Option 'traceLexer' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.debug) {
            this.commandline.createArgument().setValue("-debug");
        }
        if (this.report) {
            this.commandline.createArgument().setValue("-report");
        }
        if (this.print) {
            this.commandline.createArgument().setValue("-print");
        }
        if (this.profile) {
            this.commandline.createArgument().setValue("-profile");
        }
        if (this.messageFormatName != null) {
            this.commandline.createArgument().setValue("-message-format");
            this.commandline.createArgument().setValue(this.messageFormatName);
        }
        if (this.nfa) {
            this.commandline.createArgument().setValue("-nfa");
        }
        if (this.dfa) {
            this.commandline.createArgument().setValue("-dfa");
        }
        if (this.multiThreaded) {
            this.commandline.createArgument().setValue("-Xmultithreaded");
        }
        if (this.nocollapse) {
            this.commandline.createArgument().setValue("-Xnocollapse");
        }
        if (this.noprune) {
            this.commandline.createArgument().setValue("-Xnoprune");
        }
        if (this.dbgST) {
            this.commandline.createArgument().setValue("-XdbgST");
        }
        if (this.conversiontimeout != null) {
            this.commandline.createArgument().setValue("-Xconversiontimeout");
            this.commandline.createArgument().setValue(this.conversiontimeout);
        }
        if (this.grammarTree) {
            this.commandline.createArgument().setValue("-Xgrtree");
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null) {
            throw new BuildException("No target grammar, lexer grammar or tree parser specified!");
        }
        if (!this.target.isFile()) {
            throw new BuildException("Target: " + this.target + " is not a file!");
        }
        if (this.outputDirectory == null) {
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
        if (this.workingdir != null && !this.workingdir.isDirectory()) {
            throw new BuildException("Invalid working directory: " + this.workingdir);
        }
        if (this.libDirectory == null) {
            this.setLibdirectory(new File(this.target.getParent()));
        }
        if (!this.libDirectory.isDirectory()) {
            throw new BuildException("Invalid lib directory: " + this.libDirectory);
        }
    }

    private boolean dependencyCheck() throws BuildException {
        File f;
        CommandlineJava cmdline;
        try {
            cmdline = (CommandlineJava)this.commandline.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException("Clone of commandline failed: " + e);
        }
        cmdline.createArgument().setValue("-depend");
        cmdline.createArgument().setValue("-o");
        cmdline.createArgument().setValue(this.outputDirectory.toString());
        cmdline.createArgument().setValue("-lib");
        cmdline.createArgument().setValue(this.libDirectory.toString());
        cmdline.createArgument().setValue(this.target.toString());
        this.log(cmdline.describeCommand(), 3);
        Redirector r = new Redirector((Task)this);
        try {
            f = File.createTempFile("depend", null, this.getOutputdirectory());
            f.deleteOnExit();
            this.log("Write dependencies for '" + this.target.toString() + "' to file '" + f.getCanonicalPath() + "'", 3);
            r.setOutput(f);
            r.setAlwaysLog(false);
            r.createStreams();
        }
        catch (IOException e) {
            throw new BuildException("Redirection of output failed: " + e);
        }
        int err = 0;
        try {
            err = this.run(cmdline.getCommandline(), r.getOutputStream(), null);
        }
        catch (IOException e) {
            try {
                r.complete();
                this.log("Redirection of output terminated.", 3);
            }
            catch (IOException ex) {
                this.log("Termination of output redirection failed: " + ex, 0);
            }
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            try {
                this.bos.close();
            }
            catch (IOException e) {}
        }
        try {
            r.complete();
            this.log("Redirection of output terminated.", 3);
        }
        catch (IOException e) {
            this.log("Termination of output redirection failed: " + e, 0);
        }
        if (err != 0) {
            if (f.exists()) {
                f.delete();
            }
            if (cmdline.getClasspath() == null) {
                this.log("Antlr libraries not found in external classpath or embedded classpath statement ", 0);
            }
            this.log("Dependency check failed. ANTLR returned: " + err, 0);
            return true;
        }
        Pattern p = Pattern.compile("error\\([0-9]+\\):");
        Matcher m = p.matcher(this.bos.toString());
        if (m.find()) {
            if (f.exists()) {
                f.delete();
            }
            return true;
        }
        boolean compile = false;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
        }
        catch (IOException e) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new BuildException("Could not close file'" + f.toString() + "'.");
            }
            if (f.exists()) {
                f.delete();
            }
            try {
                throw new BuildException("Could not open '" + f.getCanonicalPath() + "' for reading.");
            }
            catch (IOException ex) {
                throw new BuildException("Could not open '" + f.toString() + "' for reading.");
            }
        }
        try {
            String s;
            while ((s = in.readLine()) != null) {
                int to = s.indexOf(": ");
                if (to < 0) continue;
                String a = s.substring(0, to).trim();
                File lhs = new File(a);
                if (!lhs.isFile()) {
                    this.log("File '" + a + "' is not a regular file", 3);
                    String name = lhs.getName();
                    String[] parts = this.splitRightHandSide(name, "\\u002E");
                    if (parts.length <= 1 && (lhs = new File(a = a + ".java")).isFile()) {
                        this.log("File '" + a + "' is a regular file last modified at " + lhs.lastModified(), 3);
                    }
                }
                String b = s.substring(to + ": ".length());
                String[] names = this.splitRightHandSide(b, ", ?");
                File aFile = new File(a);
                for (String name : names) {
                    File bFile = new File(name);
                    this.log("File '" + a + "' depends on file '" + name + "'", 3);
                    this.log("File '" + a + "' modified at " + aFile.lastModified(), 3);
                    this.log("File '" + name + "' modified at " + bFile.lastModified(), 3);
                    if (!this.fileUtils.isUpToDate(aFile, bFile)) continue;
                    this.log("Compiling " + this.target + " as '" + name + "' is newer than '" + a + "'", 3);
                    this.fileUtils.setFileLastModified(aFile, -1L);
                    this.log("Touching file '" + a + "'", 3);
                    compile = true;
                    break;
                }
                if (!compile) continue;
                break;
            }
            in.close();
        }
        catch (IOException e) {
            if (f.exists()) {
                f.delete();
            }
            throw new BuildException("Error reading file '" + f.toString() + "'");
        }
        if (f.exists()) {
            f.delete();
        }
        return compile;
    }

    private String[] splitRightHandSide(String fileNames, String pattern) {
        String[] names;
        for (String name : names = fileNames.split(pattern)) {
            this.log("Split right hand side '" + name + "'", 3);
        }
        return names;
    }

    private int run(String[] command, OutputStream out, OutputStream err) throws IOException {
        PumpStreamHandler psh = err == null ? new PumpStreamHandler(out, (OutputStream)this.bos) : new PumpStreamHandler(out, (OutputStream)new TeeOutputStream(err, (OutputStream)this.bos));
        Execute exe = new Execute((ExecuteStreamHandler)psh, null);
        exe.setAntRun(this.getProject());
        if (this.workingdir != null) {
            exe.setWorkingDirectory(this.workingdir);
        }
        exe.setCommandline(command);
        return exe.execute();
    }
}

