__author__ = 'w00322934'

from rock.db import base

class API(base.Base):
    """API for interacting with the rock manager."""

    def __init__(self, security_group_api=None, **kwargs):
        self._rock_task_api = None
        super(API, self).__init__(**kwargs)

    @property
    def rock_task_api(self):
        if self._rock_task_api is None:
            from rock import conductor
            self._rock_task_api = conductor.RockTaskAPI()
        return self._rock_task_api

    def _cell_read_only(self, cell_name):
        """Is the target cell in a read-only mode?"""
        # FIXME(comstud): Add support for this.
        return False