# Copyright 2010 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Possible accelerator types for rock.

Rock accelerator types represent what is kinds of accelerator included in rock.

"""

# accelerator function type
FUNCTION_PF = 'type-PF'
FUNCTION_VF = 'type-VF'

# accelerator device type
DEVICE_BOARD = 'ACC_BOARD'
DEVICE_QAT   = 'QAT_DEVICE'

# accelerator type
ACCELERATE_EMPTY = 'EMPTY'
ACCELERATE_CRYPTO= 'CRYPTO'

# accelerator remotable type
REMOTE_LOCAL    = '0'
REMOTE_ALL      = '1'
REMOTE_REMOTE   = '2'

"""
WARNING:
Logic driver get accelerator type from hardware as follows,
it must be modified with hardware driver together.
"""
# accelerator crypto type
# CRYPTO_EMPTY=0
# CRYPTO_SA   =1
# CRYPTO_IPSEC=2
# CRYPTO_GB   =3
#
# # accelerator child crypto type
# CRYPTO_CHILD_EMPTY=0
# CRYPTO_IPSEC_AES  =1
# CRYPTO_IPSEC_3DES =2
# CRYPTO_IPSEC_DH   =3