# Copyright 2013 Hewlett-Packard Development Company, L.P.
#
# Author: Kiall Mac Innes <kiall@hp.com>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import pecan

from designate import utils
from designate.openstack.common import log as logging
from designate.api.v2.controllers import rest
from designate.api.v2.views import nameservers as nameservers_view


LOG = logging.getLogger(__name__)


class NameServersController(rest.RestController):
    _view = nameservers_view.NameServerView()

    @pecan.expose(template='json:', content_type='application/json')
    @utils.validate_uuid('zone_id')
    def get_all(self, zone_id):
        request = pecan.request
        context = pecan.request.environ['context']

        servers = self.central_api.get_domain_servers(context, zone_id)

        return self._view.list(context, request, servers, [zone_id])
