#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
import collections

import yaml

from dragonflow import conf as cfg

# FIXME(oanson) remove when done porting
LEGACY_APP = 'dragonflow-legacy'


Vertex = collections.namedtuple(
    'Vertex',
    ('name', 'type', 'params'),
)


Edge = collections.namedtuple(
    'Edge',
    ('exitpoint', 'entrypoint'),
)


_ConnectorBase = collections.namedtuple(
    'Connector',
    ('vertex', 'direction', 'name'),
)


class Connector(_ConnectorBase):
    @classmethod
    def from_string(cls, val):
        return cls(*val.split('.'))


Layout = collections.namedtuple(
    'Layout',
    ('vertices', 'edges'),
)


def get_datapath_layout(path=None):
    if path is None:
        path = cfg.CONF.df.datapath_layout_path

    # See https://msg.pyyaml.org/load
    with open(path) as f:
        raw_layout = yaml.safe_load(f)

    vertices = tuple(
        Vertex(
            name=key,
            type=value['type'],
            params=value.get('params'),
        ) for key, value in raw_layout['vertices'].items()
    )

    edges = tuple(
        Edge(
            exitpoint=Connector.from_string(key),
            entrypoint=Connector.from_string(value),
        ) for key, value in raw_layout['edges'].items()
    )

    return Layout(vertices, edges)
