'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _get2 = require('babel-runtime/helpers/get');

var _get3 = _interopRequireDefault(_get2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _abstractService = require('./util/abstractService');

var _abstractService2 = _interopRequireDefault(_abstractService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A list of all supported versions. Please keep this array sorted by most recent.
 *
 * @type {Array}
 * @ignore
 */
var supportedKeystoneVersions = ['v3.7'];

var Keystone = function (_AbstractService) {
  (0, _inherits3.default)(Keystone, _AbstractService);

  /**
   * This class provides direct, idempotent, low-level access to the Keystone API of a specific
   * cloud. The constructor requires that you provide a configuration object for a specific
   * cloud, formatted as per the os-client-config specification of clouds.yaml. An important
   * difference is that it does not accept the entire clouds.yaml structure, only the subsection
   * that refers to a specific cloud.
   *
   * @param {{}} cloudConfig The configuration object for a specific cloud.
   * @see http://docs.openstack.org/developer/os-client-config/#site-specific-file-locations
   */
  function Keystone(cloudConfig) {
    (0, _classCallCheck3.default)(this, Keystone);

    // Sanity checks.
    if (!cloudConfig) {
      throw new Error('A configuration is required.');
    }
    // Clone the config, so that this instance is immutable
    // at runtime (no modifying the config after the fact).
    cloudConfig = (0, _assign2.default)({}, cloudConfig);

    var _this = (0, _possibleConstructorReturn3.default)(this, (Keystone.__proto__ || (0, _getPrototypeOf2.default)(Keystone)).call(this, cloudConfig.auth.auth_url, supportedKeystoneVersions));

    _this.cloudConfig = cloudConfig;
    return _this;
  }

  /**
   * This method provides a safe method for reading values deep inside of an object structure,
   * without encountering TypeErrors.
   *
   * @param {string} path A string representing the dot notation of a config path to read.
   * @private
   * @returns {String} The value found in the config, or null.
   * @ignore
   */


  (0, _createClass3.default)(Keystone, [{
    key: '_safeConfigGet',
    value: function _safeConfigGet(path) {
      var segments = path.split('.');
      var pointer = this.cloudConfig;
      while (segments.length > 0) {
        var prop = segments.shift();
        if (pointer.hasOwnProperty(prop)) {
          pointer = pointer[prop];
        } else {
          return null;
        }
      }
      return pointer;
    }

    /**
     * Retrieve all the API versions available.
     *
     * @returns {Promise.<T>} A promise that will resolve with the list of API versions.
     */

  }, {
    key: 'versions',
    value: function versions() {
      return (0, _get3.default)(Keystone.prototype.__proto__ || (0, _getPrototypeOf2.default)(Keystone.prototype), 'versions', this).call(this).then(function (versions) {
        return versions.values;
      });
    }

    /**
     * Issue a token from the provided credentials. Credentials will be read from the
     * configuration, unless they have been explicitly provided.
     *
     * NOTE: This method is only applicable if the password auth plugin on keystone is enabled.
     * Other auth methods will have to be provided by third-party developers.
     *
     * @param {Object} credentials Optional credentials.
     * @param {String} credentials.user_id An optional user ID.
     * @param {String} credentials.username An optional user name.
     * @param {String} credentials.password An optional password.
     * @param {String} credentials.user_domain_id An optional user domain ID.
     *   Not required if a user ID is given.
     * @param {String} credentials.user_domain_name An optional user domain name.
     *   Not required if a user ID is given.
     * @param {String} credentials.project_id An optional project ID.
     * @param {String} credentials.project_name An optional project name.
     * @param {String} credentials.project_domain_id An optional project domain ID.
     *   Not required if a project ID is given.
     * @param {String} credentials.project_domain_name An optional project domain name.
     *   Not required if a project ID is given.
     * @returns {Promise.<T>} A promise which will resolve with a valid token.
     */

  }, {
    key: 'tokenIssue',
    value: function tokenIssue() {
      var _this2 = this;

      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var _ref$user_id = _ref.user_id;
      var userId = _ref$user_id === undefined ? this._safeConfigGet('auth.user_id') : _ref$user_id;
      var _ref$username = _ref.username;
      var username = _ref$username === undefined ? this._safeConfigGet('auth.username') : _ref$username;
      var _ref$password = _ref.password;
      var password = _ref$password === undefined ? this._safeConfigGet('auth.password') : _ref$password;
      var _ref$user_domain_id = _ref.user_domain_id;
      var userDomainId = _ref$user_domain_id === undefined ? this._safeConfigGet('auth.user_domain_id') : _ref$user_domain_id;
      var _ref$user_domain_name = _ref.user_domain_name;
      var userDomainName = _ref$user_domain_name === undefined ? this._safeConfigGet('auth.user_domain_name') : _ref$user_domain_name;
      var _ref$project_id = _ref.project_id;
      var projectId = _ref$project_id === undefined ? this._safeConfigGet('auth.project_id') : _ref$project_id;
      var _ref$project_name = _ref.project_name;
      var projectName = _ref$project_name === undefined ? this._safeConfigGet('auth.project_name') : _ref$project_name;
      var _ref$project_domain_i = _ref.project_domain_id;
      var projectDomainId = _ref$project_domain_i === undefined ? this._safeConfigGet('auth.project_domain_id') : _ref$project_domain_i;
      var _ref$project_domain_n = _ref.project_domain_name;
      var projectDomainName = _ref$project_domain_n === undefined ? this._safeConfigGet('auth.project_domain_name') : _ref$project_domain_n;

      var project = void 0;
      var user = { password: password };

      if (userId) {
        user.id = userId;
      } else if (username) {
        user.name = username;
        if (userDomainId) {
          user.domain = { id: userDomainId };
        } else if (userDomainName) {
          user.domain = { name: userDomainName };
        } else {
          user.domain = { id: 'default' };
        }
      }

      if (projectId) {
        project = { id: projectId };
      } else if (projectName) {
        project = { name: projectName };
        if (projectDomainId) {
          project.domain = { id: projectDomainId };
        } else if (projectDomainName) {
          project.domain = { name: projectDomainName };
        } else {
          project.domain = { id: 'default' };
        }
      }

      var body = {
        auth: {
          identity: {
            methods: ['password'],
            password: { user: user }
          },
          scope: project ? { project: project } : 'unscoped'
        }
      };

      return this.serviceEndpoint().then(function (url) {
        return _this2.http.httpPost(url + 'auth/tokens', body);
      }).then(function (response) {
        return response.headers.get('X-Subject-Token');
      });
    }

    /**
     * Revoke an authorization token.
     *
     * @param {String} token The token to revoke.
     * @param {String} adminToken An optional admin token.
     * @returns {Promise.<T>} A promise which will resolve if the token has been successfully revoked.
     */

  }, {
    key: 'tokenRevoke',
    value: function tokenRevoke(token) {
      var _this3 = this;

      var adminToken = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

      return _promise2.default.all([this.serviceEndpoint(), token, adminToken]).then(function (_ref2) {
        var _ref3 = (0, _slicedToArray3.default)(_ref2, 3);

        var url = _ref3[0];
        var token = _ref3[1];
        var adminToken = _ref3[2];

        return [url, {
          'X-Subject-Token': token,
          'X-Auth-Token': adminToken || token
        }];
      }).then(function (_ref4) {
        var _ref5 = (0, _slicedToArray3.default)(_ref4, 2);

        var url = _ref5[0];
        var headers = _ref5[1];
        return _this3.http.httpRequest('DELETE', url + 'auth/tokens', headers);
      });
    }

    /**
     * Get information about a token.
     *
     * @param {String} token The authorization token.
     * @returns {Promise.<T>} A promise which will resolve with information about the token.
     */

  }, {
    key: 'tokenInfo',
    value: function tokenInfo(token) {
      var _this4 = this;

      return _promise2.default.all([this.serviceEndpoint(), token]).then(function (_ref6) {
        var _ref7 = (0, _slicedToArray3.default)(_ref6, 2);

        var url = _ref7[0];
        var token = _ref7[1];

        return [url, {
          'X-Subject-Token': token,
          'X-Auth-Token': token
        }];
      }).then(function (_ref8) {
        var _ref9 = (0, _slicedToArray3.default)(_ref8, 2);

        var url = _ref9[0];
        var headers = _ref9[1];
        return _this4.http.httpRequest('GET', url + 'auth/tokens', headers);
      }).then(function (response) {
        return response.json();
      });
    }

    /**
     * List the service catalog for the configured cloud.
     *
     * @param {String} token The authorization token.
     * @returns {Promise.<T>} A promise which will resolve with the service catalog.
     */

  }, {
    key: 'catalogList',
    value: function catalogList() {
      var _this5 = this;

      var token = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      return this._requestComponents(token).then(function (_ref10) {
        var _ref11 = (0, _slicedToArray3.default)(_ref10, 2);

        var url = _ref11[0];
        var headers = _ref11[1];
        return _this5.http.httpRequest('GET', url + 'auth/catalog', headers);
      }).then(function (response) {
        return response.json();
      }).then(function (body) {
        return body.catalog;
      });
    }
  }]);
  return Keystone;
}(_abstractService2.default);

exports.default = Keystone;