"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require("babel-runtime/core-js/promise");

var _promise2 = _interopRequireDefault(_promise);

var _assign = require("babel-runtime/core-js/object/assign");

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

var _keystone = require("./keystone");

var _keystone2 = _interopRequireDefault(_keystone);

var _neutron = require("./neutron");

var _neutron2 = _interopRequireDefault(_neutron);

var _glance = require("./glance");

var _glance2 = _interopRequireDefault(_glance);

var _nova = require("./nova");

var _nova2 = _interopRequireDefault(_nova);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var OpenStack = function () {
  /**
   * Create wrapper class that takes clouds.yaml instance
   *
   * @param {{}} cloudConfig The configuration object for a specific cloud.
   */
  function OpenStack(cloudConfig) {
    (0, _classCallCheck3.default)(this, OpenStack);

    // Sanity checks.
    if (!cloudConfig) {
      throw new Error('A configuration is required.');
    }
    // Clone the config, so that this instance is immutable
    // at runtime (no modifying the config after the fact).
    cloudConfig = (0, _assign2.default)({}, cloudConfig);

    this.cloudConfig = cloudConfig;
  }

  (0, _createClass3.default)(OpenStack, [{
    key: "getConfig",
    value: function getConfig() {
      // Returns the config instance
      return this.cloudConfig;
    }

    /**
     * List the networks available.
     *
     * @returns {Promise.<T>} A promise which will resolve with the list of networks.
     */

  }, {
    key: "networkList",
    value: function networkList() {
      var _this = this;

      return this._neutron.then(function (neutron) {
        return neutron.networkList(_this._token);
      });
    }

    /**
     * List the images available on glance.
     *
     * @returns {Promise.<T>} A promise which will resolve with the list of images.
     */

  }, {
    key: "imageList",
    value: function imageList() {
      var _this2 = this;

      return this._glance.then(function (glance) {
        return glance.imageList(_this2._token);
      });
    }

    /**
     * List the flavors available on nova.
     *
     * @returns {Promise.<T>} A promise which will resolve with the list of flavors.
     */

  }, {
    key: "flavorList",
    value: function flavorList() {
      var _this3 = this;

      return this._nova.then(function (nova) {
        return nova.flavorList(_this3._token);
      });
    }

    /**
     * Keystone component.
     *
     * @returns {Promise.<Keystone>} A promise which will resolve with Keystone instance.
     * @private
     */

  }, {
    key: "_getComponentConfigFor",


    /**
     * Return an component config from keystone catalog.
     *
     * @param {String} name A component name to find.
     * @returns {Promise.<{}>} A promise which will resolve with the component config.
     * @private
     */
    value: function _getComponentConfigFor(name) {
      var _this4 = this;

      var config = this.getConfig();
      return this._token.then(function (token) {
        return _this4._keystone.then(function (keystone) {
          return keystone.catalogList(token);
        });
      }).then(function (catalog) {
        return catalog.find(function (entry) {
          return entry.name === name;
        });
      }).then(function (entry) {
        return entry.endpoints.find(function (endpoint) {
          return endpoint.region === config.region_name && endpoint.interface === 'public';
        });
      });
    }
  }, {
    key: "_keystone",
    get: function get() {
      if (!this._keystonePromise) {
        this._keystonePromise = _promise2.default.resolve(new _keystone2.default(this.getConfig()));
      }

      return this._keystonePromise;
    }

    /**
     * Neutron component.
     *
     * @returns {Promise.<Neutron>} A promise which will resolve with Neutron instance.
     * @private
     */

  }, {
    key: "_neutron",
    get: function get() {
      if (!this._neutronPromise) {
        this._neutronPromise = this._getComponentConfigFor('neutron').then(function (componentConfig) {
          return new _neutron2.default(componentConfig);
        });
      }
      return this._neutronPromise;
    }

    /**
     * Glance component.
     *
     * @returns {Promise.<Glance>} A promise which will resolve with Glance instance.
     * @private
     */

  }, {
    key: "_glance",
    get: function get() {
      if (!this._glancePromise) {
        this._glancePromise = this._getComponentConfigFor('glance').then(function (componentConfig) {
          return new _glance2.default(componentConfig);
        });
      }
      return this._glancePromise;
    }

    /**
     * Nova component.
     *
     * @returns {Promise.<Nova>} A promise which will resolve with Nova instance.
     * @private
     */

  }, {
    key: "_nova",
    get: function get() {
      if (!this._novaPromise) {
        this._novaPromise = this._getComponentConfigFor('nova').then(function (componentConfig) {
          return new _nova2.default(componentConfig);
        });
      }
      return this._novaPromise;
    }

    /**
     * Token issued from Keystone.
     *
     * @returns {Promise.<T>} A promise which will resolve with the token.
     * @private
     */

  }, {
    key: "_token",
    get: function get() {
      if (!this._tokenPromise) {
        this._tokenPromise = this._keystone.then(function (k) {
          return k.tokenIssue();
        });
      }
      return this._tokenPromise;
    }
  }]);
  return OpenStack;
}();

exports.default = OpenStack;