'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _abstractService = require('./util/abstractService');

var _abstractService2 = _interopRequireDefault(_abstractService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A list of all supported versions. Please keep this array sorted by most recent.
 *
 * @type {Array}
 * @ignore
 */
var supportedGlanceVersions = ['v2.3']; /*
                                         * Copyright (c) 2016 Hewlett Packard Enterprise Development L.P.
                                         *
                                         * Licensed under the Apache License, Version 2.0 (the "License"); you may not
                                         * use this file except in compliance with the License. You may obtain a copy
                                         * of the License at
                                         *
                                         * http://www.apache.org/licenses/LICENSE-2.0
                                         *
                                         * Unless required by applicable law or agreed to in writing, software
                                         * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
                                         * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
                                         * the License for the specific language governing permissions and limitations
                                         * under the License.
                                         */

var Glance = function (_AbstractService) {
  (0, _inherits3.default)(Glance, _AbstractService);

  /**
   * This class provides direct, idempotent, low-level access to the Glance API of a specific
   * cloud. The constructor requires that you provide a specific glance interface endpoint
   * descriptor, as received from keystone's catalog list.
   *
   * @example
   * {
   *   region_id: "RegionOne",
   *   url: "http://127.0.0.1:9292",
   *   region: "RegionOne",
   *   interface: "admin",
   *   id: "0b8b5f0f14904136ab5a4f83f27ec49a"
   * }
   * @param {{}} endpointConfig The configuration element for a specific glance endpoint.
   */
  function Glance(endpointConfig) {
    (0, _classCallCheck3.default)(this, Glance);

    // Sanity checks.
    if (!endpointConfig || !endpointConfig.url) {
      throw new Error('An endpoint configuration is required.');
    }
    // Clone the config, so that this instance is immutable
    // at runtime (no modifying the config after the fact).
    endpointConfig = (0, _assign2.default)({}, endpointConfig);

    var _this = (0, _possibleConstructorReturn3.default)(this, (Glance.__proto__ || (0, _getPrototypeOf2.default)(Glance)).call(this, endpointConfig.url, supportedGlanceVersions));

    _this._config = endpointConfig;
    return _this;
  }

  /**
   * List the images available on glance.
   *
   * @param {(String|Promise.<T>)} token An authorization token, or a promise which will resolve
   * into one.
   * @returns {Promise.<T>} A promise which will resolve with the list of images.
   */


  (0, _createClass3.default)(Glance, [{
    key: 'imageList',
    value: function imageList() {
      var _this2 = this;

      var token = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      return this._requestComponents(token).then(function (_ref) {
        var _ref2 = (0, _slicedToArray3.default)(_ref, 2),
            url = _ref2[0],
            headers = _ref2[1];

        return _this2.http.httpRequest('GET', url + 'images', headers);
      }).then(function (response) {
        return response.json();
      }).then(function (body) {
        return body.images;
      });
    }
  }]);
  return Glance;
}(_abstractService2.default);

exports.default = Glance;