'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _http = require('./http');

var _http2 = _interopRequireDefault(_http);

var _urlParse = require('url-parse');

var _urlParse2 = _interopRequireDefault(_urlParse);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright (c) 2016 Hewlett Packard Enterprise Development L.P.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations
 * under the License.
 */

var AbstractService = function () {

  /**
   * This class provides an abstract implementation of our services, which includes logic common to
   * all of our services.
   *
   * @param {string} endpointUrl The endpoint URL.
   * @param {Array} supportedVersions The list of all supported versions.
   */
  function AbstractService(endpointUrl, supportedVersions) {
    (0, _classCallCheck3.default)(this, AbstractService);

    this._endpointUrl = endpointUrl;
    this._supportedVersions = supportedVersions;
  }

  /**
   * Our HTTP service instance.
   *
   * @returns {Http} Our HTTP service instance.
   */


  (0, _createClass3.default)(AbstractService, [{
    key: 'versions',


    /**
     * Retrieve all the API versions available.
     *
     * @returns {Promise.<T>} A promise that will resolve with the list of API versions.
     */
    value: function versions() {
      var _this = this;

      return new _promise2.default(function (resolve, reject) {
        var promise = _this.http.httpGet(_this._endpointUrl).catch(function (response) {
          if (response.status === 401) {
            var rootUrl = new _urlParse2.default(_this._endpointUrl);
            rootUrl.set('pathname', '/');
            rootUrl.set('query', '');
            rootUrl.set('hash', '');

            return _this.http.httpGet(rootUrl.href);
          } else {
            return reject(response);
          }
        });

        promise.then(function (response) {
          return response.json();
        }).then(function (body) {
          return resolve(body.versions);
        });
      });
    }

    /**
     * Retrieve the API version declaration that is currently in use by this instance.
     *
     * @returns {Promise.<T>} A promise that will resolve with the specific API version.
     */

  }, {
    key: 'version',
    value: function version() {
      var _this2 = this;

      return this.versions().then(function (versions) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = (0, _getIterator3.default)(versions), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var version = _step.value;

            if (_this2.supportedVersions.indexOf(version.id) > -1) {
              return version;
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        throw new Error("No supported API version available.");
      });
    }

    /**
     * Return the root API endpoint for the current supported glance version.
     *
     * @returns {Promise.<T>|*} A promise which will resolve with the endpoint URL string.
     */

  }, {
    key: 'serviceEndpoint',
    value: function serviceEndpoint() {
      if (!this._endpointPromise) {
        this._endpointPromise = this.version().then(function (version) {
          if (version.links) {
            for (var i = 0; i < version.links.length; i++) {
              var link = version.links[i];
              if (link.rel === 'self' && link.href) {
                return link.href;
              }
            }
          }
          throw new Error("No service endpoint discovered.");
        });
      }
      return this._endpointPromise;
    }

    /**
     * This method builds common components for a request to the implemented service.
     * It converts any passed token into a promise, resolves the base URL, and then passes
     * the results as an .all() promise, which may be destructured in a followup request.
     *
     * @param {Promise|String} token A promise, or string, representing a token.
     * @returns {Promise} A promise which resolves with [url, token].
     * @private
     */

  }, {
    key: '_requestComponents',
    value: function _requestComponents() {
      var token = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      // Make sure the token is a promise.
      var headerPromise = _promise2.default.resolve(token).then(function (token) {
        if (token) {
          return {
            'X-Auth-Token': token
          };
        }
        return {};
      });
      return _promise2.default.all([this.serviceEndpoint(), headerPromise]);
    }
  }, {
    key: 'http',
    get: function get() {
      if (!this._http) {
        this._http = new _http2.default();
      }
      return this._http;
    }

    /**
     * List of all supported versions.
     *
     * @returns {Array} The list of all supported versions, or empty array.
     */

  }, {
    key: 'supportedVersions',
    get: function get() {
      return this._supportedVersions || [];
    }

    /**
     * Our endpoint URL for this service.
     *
     * @returns {string} The URL of our service.
     */

  }, {
    key: 'endpointUrl',
    get: function get() {
      return this._endpointUrl;
    }
  }]);
  return AbstractService;
}();

exports.default = AbstractService;