'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

require('isomorphic-fetch');

var _loglevel = require('loglevel');

var _loglevel2 = _interopRequireDefault(_loglevel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This utility class provides an abstraction layer for HTTP calls via fetch(). Its purpose is
 * to provide common, SDK-wide behavior for all HTTP requests. Included are:
 *
 * - Access to default headers.
 * - Convenience GET/PUT/POST/DELETE methods.
 * - Passing 4xx and 5xx responses to the catch() handler.
 *
 * In the future, this class chould also be extended to provide:
 *
 * - Some form of progress() support for large uploads and downloads (perhaps via introduction of Q)
 * - Convenience decoding of the response body, depending on Content-Type.
 * - Internal error handling (At this time, HTTP errors are passed to then() rather than catch()).
 * - Other features.
 */
/*
 * Copyright (c) 2016 Hewlett Packard Enterprise Development L.P.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations
 * under the License.
 */

var Http = function () {
  (0, _createClass3.default)(Http, [{
    key: 'defaultHeaders',


    /**
     * The default headers which will be sent with every request. A copy of these headers will be
     * added to the Request instance passed through the interceptor chain, and may be
     * modified there.
     *
     * @returns {{string: string}} A mapping of 'headerName': 'headerValue'
     */
    get: function get() {
      return this._defaultHeaders;
    }

    /**
     * Create a new HTTP handler.
     */

  }]);

  function Http() {
    (0, _classCallCheck3.default)(this, Http);

    // Add default response interceptors.
    this._defaultHeaders = {
      'Content-Type': 'application/json'
    };
  }

  /**
   * Make a decorated HTTP request.
   *
   * @param {String} method The HTTP method.
   * @param {String} url The request URL.
   * @param {{}} headers A map of HTTP headers.
   * @param {{}} body The body. It will be JSON-Encoded by the handler.
   * @returns {Promise} A promise which will resolve with the processed request response.
   */


  (0, _createClass3.default)(Http, [{
    key: 'httpRequest',
    value: function httpRequest(method, url) {
      var headers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var body = arguments[3];


      // Sanitize the headers...
      headers = (0, _assign2.default)({}, headers, this.defaultHeaders);

      // Build the request
      var init = { method: method, headers: headers };

      // The Request() constructor will throw an error if the method is GET/HEAD, and there's a body.
      if (['GET', 'HEAD'].indexOf(method) === -1 && body) {
        init.body = (0, _stringify2.default)(body);
      }
      var request = new Request(url, init);

      // Build the wrapper promise.
      return new _promise2.default(function (resolve, reject) {
        _loglevel2.default.debug('-->', 'HTTP ' + method, url, (0, _stringify2.default)(headers), (0, _stringify2.default)(body));
        var promise = fetch(request.url, init);

        // Fetch will treat all http responses (2xx, 3xx, 4xx, 5xx, etc) as successful responses.
        // This will catch all 4xx and 5xx responses and return them to the catch() handler. Note
        // that it's up to the downstream developer to determine whether what they received is an
        // error or a failed response.
        promise.then(function (response) {
          _loglevel2.default.debug('<--', 'HTTP ' + response.status);
          if (response.status >= 400) {
            return reject(response);
          } else {
            return response;
          }
        });

        promise.then(function (response) {
          return resolve(response);
        }, function (error) {
          return reject(error);
        });
      });
    }

    /**
     * Make a raw GET request against a particular URL.
     *
     * @param {String} url The request URL.
     * @returns {Promise} A promise which will resolve with the processed request response.
     */

  }, {
    key: 'httpGet',
    value: function httpGet(url) {
      return this.httpRequest('GET', url, {}, null);
    }

    /**
     * Make a raw PUT request against a particular URL.
     *
     * @param {String} url The request URL.
     * @param {{}} body The body. It will be JSON-Encoded by the handler.
     * @returns {Promise} A promise which will resolve with the processed request response.
     */

  }, {
    key: 'httpPut',
    value: function httpPut(url, body) {
      return this.httpRequest('PUT', url, {}, body);
    }

    /**
     * Make a raw POST request against a particular URL.
     *
     * @param {String} url The request URL.
     * @param {{}} body The body. It will be JSON-Encoded by the handler.
     * @returns {Promise} A promise which will resolve with the processed request response.
     */

  }, {
    key: 'httpPost',
    value: function httpPost(url, body) {
      return this.httpRequest('POST', url, {}, body);
    }

    /**
     * Make a raw DELETE request against a particular URL.
     *
     * @param {String} url The request URL.
     * @returns {Promise} A promise which will resolve with the processed request response.
     */

  }, {
    key: 'httpDelete',
    value: function httpDelete(url) {
      return this.httpRequest('DELETE', url, {}, null);
    }
  }]);
  return Http;
}();

exports.default = Http;