#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Add indexes to `user_id` and `trust_id` columns for the `token` table."""

import sqlalchemy as sql


def upgrade(migrate_engine):
    meta = sql.MetaData()
    meta.bind = migrate_engine

    token = sql.Table('token', meta, autoload=True)

    sql.Index('ix_token_user_id', token.c.user_id).create()
    sql.Index('ix_token_trust_id', token.c.trust_id).create()


def downgrade(migrate_engine):
    meta = sql.MetaData()
    meta.bind = migrate_engine

    token = sql.Table('token', meta, autoload=True)

    sql.Index('ix_token_user_id', token.c.user_id).drop()
    sql.Index('ix_token_trust_id', token.c.trust_id).drop()
