# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.


class InvalidToken(Exception):
    pass


class ServiceError(Exception):
    pass


class ConfigurationError(Exception):
    pass


class RevocationListError(Exception):
    pass


# NOTE(jamielennox): This exception is only available in this version to
# maintain compatibility of a backported patch. In newer auth_token middleware
# where webob is available it corresponds to raise
# webob.exc.HTTPInternalServerError(). It is not available in later versions of
# auth_token middleware and should not be used.
class _InternalServiceError(Exception):
    pass
