#!/bin/bash

set -o xtrace
set -o errexit

# Enable unbuffered output for Ansible in Jenkins.
export PYTHONUNBUFFERED=1


function test_bifrost {
    container_engine="${1:-docker}"

    # TODO(mgoddard): More testing, deploy bare metal nodes.
    # TODO(mgoddard): Use openstackclient when clouds.yaml works. See
    # https://bugs.launchpad.net/bifrost/+bug/1754070.
    attempts=0
    while [[ $(sudo ${container_engine} exec bifrost_deploy bash -c "OS_CLOUD=bifrost baremetal driver list -f value" | wc -l) -eq 0 ]]; do
        attempts=$((attempts + 1))
        if [[ $attempts -gt 6 ]]; then
            echo "Timed out waiting for ironic conductor to become active"
            exit 1
        fi
        sleep 10
    done
    sudo $container_engine exec bifrost_deploy bash -c "OS_CLOUD=bifrost baremetal node list"
    sudo $container_engine exec bifrost_deploy bash -c "OS_CLOUD=bifrost baremetal node create --driver redfish --name test-node"
    sudo $container_engine exec bifrost_deploy bash -c "OS_CLOUD=bifrost baremetal node delete test-node"
}


test_bifrost $1
