FROM centos:7
LABEL authors="Antoni Segura Puimedon<toni@kuryr.org>, Michał Dulko<mdulko@redhat.com>"

ARG UPPER_CONSTRAINTS_FILE="https://opendev.org/openstack/requirements/raw/branch/stable/rocky/upper-constraints.txt"
ARG OSLO_LOCK_PATH=/var/kuryr-lock
ARG PKG_YUM_REPO=https://rdoproject.org/repos/openstack-rocky/rdo-release-rocky-0.noarch.rpm

RUN yum install -y epel-release $PKG_YUM_REPO \
    && yum install -y --setopt=tsflags=nodocs python-pip iproute bridge-utils openvswitch sudo jq \
    && yum install -y --setopt=tsflags=nodocs gcc python-devel git \
    && pip install -U setuptools==40.0.0

COPY . /opt/kuryr-kubernetes

RUN cd /opt/kuryr-kubernetes \
    && pip install -c $UPPER_CONSTRAINTS_FILE . \
    && rm -fr .git \
    && yum -y history undo last \
    && mkdir ${OSLO_LOCK_PATH}

COPY ./cni_ds_init /usr/bin/cni_ds_init

ARG CNI_CONFIG_DIR_PATH=/etc/cni/net.d
ENV CNI_CONFIG_DIR_PATH ${CNI_CONFIG_DIR_PATH}
ARG CNI_BIN_DIR_PATH=/opt/cni/bin
ENV CNI_BIN_DIR_PATH ${CNI_BIN_DIR_PATH}
ARG CNI_DAEMON=True
ENV CNI_DAEMON ${CNI_DAEMON}
ENV OSLO_LOCK_PATH=${OSLO_LOCK_PATH}

VOLUME [ "/sys/fs/cgroup" ]
ENTRYPOINT [ "cni_ds_init" ]
