# Copyright 2014 - Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

from oslo.config import cfg

from mistral.db.v2 import api as db_api
from mistral.openstack.common import log as logging
from mistral.services import workbooks as wb_service
from mistral.tests.unit.engine1 import base

LOG = logging.getLogger(__name__)

# Use the set_default method to set value otherwise in certain test cases
# the change in value is not permanent.
cfg.CONF.set_default('auth_enable', False, group='pecan')


WORKBOOK = """
---
version: '2.0'

name: my_wb

actions:
  concat_twice:
    base: std.echo
    base-input:
      output: "{$.s1}+{$.s2}"
    input:
      - s1
      - s2
    output: "{$} and {$}"

workflows:
  wf1:
    type: direct
    input:
      - str1
      - str2
    output:
      workflow_result: $.result # This access to execution context variables
      concat_task_result: $.task.concat # This access to task raw result

    tasks:
      concat:
        action: concat_twice s1={$.str1} s2={$.str2}
        publish:
          result: $
"""


class AdhocActionsTest(base.EngineTestCase):
    def setUp(self):
        super(AdhocActionsTest, self).setUp()

        wb_service.create_workbook_v2({
            'name': 'my_wb',
            'definition': WORKBOOK,
            'tags': ['test']
        })

    def test_run_workflow_with_adhoc_action(self):
        exec_db = self.engine.start_workflow(
            'my_wb.wf1',
            {'str1': 'a', 'str2': 'b'}
        )

        self._await(lambda: self.is_execution_success(exec_db.id))

        exec_db = db_api.get_execution(exec_db.id)

        self.assertDictEqual(
            {
                'workflow_result': 'a+b and a+b',
                'concat_task_result': 'a+b and a+b'
            },
            exec_db.output
        )
