/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.HashMap;
import java.util.LinkedList;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JMXAttribute;
import org.datadog.jmxfetch.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleReporter
extends Reporter {
    private LinkedList<HashMap<String, Object>> metrics = new LinkedList();

    @Override
    protected void _sendMetricPoint(String metricName, double value, String[] tags) {
        String tagString = "[" + this.join(", ", tags) + "]";
        System.out.println(metricName + tagString + " - " + System.currentTimeMillis() / 1000L + " = " + value);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", metricName);
        m.put("value", value);
        m.put("tags", tags);
        this.metrics.add(m);
    }

    public LinkedList<HashMap<String, Object>> getMetrics() {
        LinkedList<HashMap<String, Object>> returned_metrics = this.metrics;
        this.metrics = new LinkedList();
        return returned_metrics;
    }

    public String join(String delim, String ... data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            if (i >= data.length - 1) break;
            sb.append(delim);
        }
        return sb.toString();
    }

    @Override
    public void displayMetricReached() {
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("       ------- METRIC LIMIT REACHED: ATTRIBUTES BELOW WON'T BE COLLECTED -------");
        System.out.println();
        System.out.println();
        System.out.println();
    }

    @Override
    public void displayMatchingAttributeName(JMXAttribute jmxAttribute, int rank, int limit) {
        System.out.println("       Matching: " + rank + "/" + limit + ". " + jmxAttribute);
    }

    @Override
    public void displayNonMatchingAttributeName(JMXAttribute jmxAttribute) {
        System.out.println("       Not Matching: " + jmxAttribute);
    }

    @Override
    public void displayInstanceName(Instance instance) {
        System.out.println();
        System.out.println("#####################################");
        System.out.println("Instance: " + instance);
        System.out.println("#####################################");
        System.out.println();
    }
}

