/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JMXAttribute;
import org.datadog.jmxfetch.Reporter;

public class StatsdReporter
extends Reporter {
    private StatsDClient STATSD_CLIENT;
    private int statsd_port;
    private long initializationTime;

    public StatsdReporter(int statsd_port) {
        this.statsd_port = statsd_port;
        this.init();
    }

    private void init() {
        this.initializationTime = System.currentTimeMillis();
        this.STATSD_CLIENT = new NonBlockingStatsDClient(null, "localhost", this.statsd_port, new String[0]);
    }

    protected void _sendMetricPoint(String metricName, double value, String[] tags) {
        if (System.currentTimeMillis() - this.initializationTime > 300000L) {
            this.STATSD_CLIENT.stop();
            this.init();
        }
        this.STATSD_CLIENT.gauge(metricName, value, tags);
    }

    public void displayMetricReached() {
        throw new UnsupportedOperationException();
    }

    public void displayMatchingAttributeName(JMXAttribute jmxAttribute, int rank, int limit) {
        throw new UnsupportedOperationException();
    }

    public void displayNonMatchingAttributeName(JMXAttribute jmxAttribute) {
        throw new UnsupportedOperationException();
    }

    public void displayInstanceName(Instance instance) {
        throw new UnsupportedOperationException();
    }
}

