/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    private HashMap<Object, Object> parsedYaml;

    public YamlParser(String path) throws FileNotFoundException {
        FileInputStream yaml_file = new FileInputStream(path);
        this.init(yaml_file);
    }

    public YamlParser(InputStream yamlInputStream) {
        this.init(yamlInputStream);
    }

    private void init(InputStream yamlInputStream) {
        Yaml yaml = new Yaml();
        this.parsedYaml = (HashMap)yaml.load(yamlInputStream);
    }

    public Object getInitConfig() {
        return this.parsedYaml.get("init_config");
    }

    public Object getYamlInstances() {
        return this.parsedYaml.get("instances");
    }

    public Object getParsedYaml() {
        return this.parsedYaml;
    }

    public boolean isJmx() {
        try {
            return (Boolean)((HashMap)this.parsedYaml.get("init_config")).get("is_jmx");
        }
        catch (Exception e) {
            return false;
        }
    }
}

