/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectInstance;
import javax.management.ReflectionException;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXAttribute {
    protected MBeanAttributeInfo attribute;
    protected Connection connection;
    protected ObjectInstance jmxInstance;
    protected double value;
    protected String domain;
    protected String beanName;
    protected String attributeName;
    protected LinkedHashMap<Object, Object> valueConversions;
    protected String[] tags;
    protected Configuration matching_conf;
    private static final String[] EXCLUDED_BEAN_PARAMS = new String[]{"domain", "bean_name", "bean", "attribute"};
    private static final String FIRST_CAP_PATTERN = "(.)([A-Z][a-z]+)";
    private static final String ALL_CAP_PATTERN = "([a-z0-9])([A-Z])";
    private static final String METRIC_REPLACEMENT = "([^a-zA-Z0-9_.]+)|(^[^a-zA-Z]+)";
    private static final String DOT_UNDERSCORE = "_*\\._*";

    public JMXAttribute(MBeanAttributeInfo a, ObjectInstance jmxInstance, String instanceName, Connection connection, HashMap<String, String> instanceTags) {
        this.attribute = a;
        this.jmxInstance = jmxInstance;
        this.matching_conf = null;
        this.connection = connection;
        this.beanName = jmxInstance.getObjectName().toString();
        String[] split = this.beanName.split(":");
        this.domain = split[0];
        this.attributeName = a.getName();
        LinkedList<String> beanTags = new LinkedList<String>(Arrays.asList(split[1].replace("=", ":").split(",")));
        beanTags.add("instance:" + instanceName);
        beanTags.add("jmx_domain:" + this.domain);
        if (instanceTags != null) {
            for (Map.Entry<String, String> tag : instanceTags.entrySet()) {
                beanTags.add(tag.getKey() + ":" + tag.getValue());
            }
        }
        this.tags = new String[beanTags.size()];
        beanTags.toArray(this.tags);
    }

    public String toString() {
        return "Bean name: " + this.beanName + " - Attribute name: " + this.attributeName + "  - Attribute type: " + this.attribute.getType();
    }

    public abstract LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException;

    public abstract boolean match(Configuration var1);

    public int getMetricsCount() {
        try {
            return this.getMetrics().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected Object getJmxValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.connection.getAttribute(this.jmxInstance.getObjectName(), this.attribute.getName());
    }

    protected boolean matchDomain(Configuration conf) {
        return conf.include.get("domain") == null || ((String)conf.include.get("domain")).equals(this.domain);
    }

    protected boolean excludeMatchDomain(Configuration conf) {
        return conf.exclude.get("domain") != null && ((String)conf.exclude.get("domain")).equals(this.domain);
    }

    protected boolean excludeMatchBean(Configuration conf) {
        String bean = (String)conf.exclude.get("bean");
        String confBeanName = (String)conf.exclude.get("bean_name");
        if (this.beanName.equals(bean) || this.beanName.equals(confBeanName)) {
            return true;
        }
        for (String bean_attr : conf.exclude.keySet()) {
            if (Arrays.asList(EXCLUDED_BEAN_PARAMS).contains(bean_attr)) continue;
            HashMap<String, String> beanParams = new HashMap<String, String>();
            for (String param : this.tags) {
                String[] paramSplit = param.split(":");
                beanParams.put(paramSplit[0], paramSplit[1]);
            }
            if (!conf.exclude.get(bean_attr).equals(beanParams.get(bean_attr))) continue;
            return true;
        }
        return false;
    }

    protected static String convertMetricName(String metricName) {
        metricName = metricName.replaceAll(FIRST_CAP_PATTERN, "$1_$2");
        metricName = metricName.replaceAll(ALL_CAP_PATTERN, "$1_$2").toLowerCase();
        metricName = metricName.replaceAll(METRIC_REPLACEMENT, "_");
        metricName = metricName.replaceAll(DOT_UNDERSCORE, ".").trim();
        return metricName;
    }

    protected Object convertMetricValue(Object metricValue) {
        Object converted = metricValue;
        if (!this.getValueConversions().isEmpty() && (converted = this.getValueConversions().get(metricValue)) == null && this.getValueConversions().get("default") != null) {
            converted = this.getValueConversions().get("default");
        }
        return converted;
    }

    protected double _getValueAsDouble(Object metricValue) {
        Object value = this.convertMetricValue(metricValue);
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof AtomicInteger) {
            return new Double(((AtomicInteger)value).get());
        }
        if (value instanceof AtomicLong) {
            Long l = ((AtomicLong)value).get();
            return l.doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Long) {
            Long l = new Long((Long)value);
            return l.doubleValue();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return new Double((Double)value);
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
    }

    protected boolean matchBean(Configuration configuration) {
        boolean matchBeanName = false;
        if (configuration.include.get("bean") == null && configuration.include.get("bean_name") == null) {
            matchBeanName = true;
        } else if (configuration.include.get("bean") != null) {
            matchBeanName = ((String)configuration.include.get("bean")).equals(this.beanName);
        } else if (configuration.include.get("bean_name") != null) {
            matchBeanName = ((String)configuration.include.get("bean_name")).equals(this.beanName);
        }
        if (!matchBeanName) {
            return false;
        }
        for (String bean_attr : configuration.include.keySet()) {
            if (Arrays.asList(EXCLUDED_BEAN_PARAMS).contains(bean_attr)) continue;
            HashMap<String, String> beanParams = new HashMap<String, String>();
            for (String param : this.tags) {
                String[] paramSplit = param.split(":");
                beanParams.put(paramSplit[0], paramSplit[1]);
            }
            if (beanParams.get(bean_attr) != null && ((String)beanParams.get(bean_attr)).equals((String)configuration.include.get(bean_attr))) continue;
            return false;
        }
        return true;
    }

    protected HashMap<Object, Object> getValueConversions() {
        if (this.valueConversions == null) {
            LinkedHashMap attribute;
            if (this.matching_conf.include.get("attribute") instanceof LinkedHashMap && (attribute = (LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(this.attribute.getName())) != null) {
                this.valueConversions = (LinkedHashMap)attribute.get("values");
            }
            if (this.valueConversions == null) {
                this.valueConversions = new LinkedHashMap();
            }
        }
        return this.valueConversions;
    }
}

