/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.CustomLogger;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.Reporter;
import org.datadog.jmxfetch.Status;
import org.datadog.jmxfetch.YamlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class App {
    private static ArrayList<Instance> _instances = new ArrayList();
    private static LinkedList<Instance> _brokenInstances = new LinkedList();
    private static final Logger LOGGER = Logger.getLogger(App.class.getName());
    private static int _loopCounter;

    public static void main(String[] args) {
        AppConfig config = AppConfig.getInstance();
        JCommander jCommander = null;
        try {
            jCommander = new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (config.help || config.getAction().equals("help")) {
            jCommander.usage();
            System.exit(0);
        }
        try {
            CustomLogger.setup(Level.toLevel(config.logLevel), config.logLocation);
        }
        catch (IOException e) {
            LOGGER.error("Unable to setup file handler to file: " + config.logLocation, e);
        }
        if (!AppConfig.ACTIONS.contains(config.getAction())) {
            LOGGER.fatal(config.getAction() + " is not in " + AppConfig.ACTIONS + ". Exiting.");
            System.exit(1);
        }
        if (!config.getAction().equals("collect") && !config.isConsoleReporter()) {
            LOGGER.fatal(config.getAction() + " argument can only be used with the console reporter. Exiting.");
            System.exit(1);
        }
        App.attachShutdownHook();
        LOGGER.info("JMX Fetch has started");
        App.init(config, false);
        if (config.getAction().equals("collect")) {
            App._doLoop(config);
        }
    }

    private static void attachShutdownHook() {
        class ShutdownHook {
            ShutdownHook() {
            }

            public void attachShutDownHook() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        LOGGER.info("JMXFetch is closing");
                        Status.getInstance().deleteStatus();
                        Enumeration enume = LOGGER.getAllAppenders();
                        while (enume.hasMoreElements()) {
                            Appender h = (Appender)enume.nextElement();
                            h.close();
                        }
                    }
                });
            }
        }
        ShutdownHook shutdownHook = new ShutdownHook();
        shutdownHook.attachShutDownHook();
    }

    private static void _doLoop(AppConfig config) {
        while (true) {
            long start = System.currentTimeMillis();
            if (_instances.size() > 0) {
                App.doIteration(config);
            } else {
                LOGGER.warn("No instance could be initiated. Retrying initialization.");
                config.status.flush();
                App.init(config, true);
            }
            long length = System.currentTimeMillis() - start;
            LOGGER.debug("Iteration ran in " + length + " ms");
            try {
                LOGGER.debug("Sleeping for " + config.loopPeriod + " ms.");
                Thread.sleep(config.loopPeriod);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public static void doIteration(AppConfig config) {
        ++_loopCounter;
        Reporter reporter = config.reporter;
        for (Instance instance : _instances) {
            LinkedList<HashMap<String, Object>> metrics;
            String instanceStatus = "OK";
            String instanceMessage = null;
            try {
                metrics = instance.getMetrics();
            }
            catch (IOException e) {
                String warning = "Unable to refresh bean list for instance " + instance;
                LOGGER.warn(warning, e);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
                _brokenInstances.add(instance);
                continue;
            }
            if (metrics.size() == 0) {
                String warning = "Instance " + instance + " didn't return any metrics";
                LOGGER.warn(warning);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
                _brokenInstances.add(instance);
                continue;
            }
            if (instance.isLimitReached()) {
                instanceMessage = "Number of returned metrics is too high for instance: " + instance.getName() + ". Please read http://docs.datadoghq.com/integrations/java/ or get in touch with Datadog Support for more details. Truncating to " + instance.getMaxNumberOfMetrics() + " metrics.";
                instanceStatus = "WARNING";
                CustomLogger.laconic(LOGGER, Level.WARN, instanceMessage, 0);
            }
            reporter.sendMetrics(metrics, instance.getName());
            config.status.addInstanceStats(instance.getCheckName(), instance.getName(), metrics.size(), instanceMessage, instanceStatus);
        }
        Iterator<Instance> it = _brokenInstances.iterator();
        while (it.hasNext()) {
            String warning;
            Instance instance;
            instance = it.next();
            reporter.clearRatesAggregator(instance.getName());
            LOGGER.warn("Instance " + instance + " didn't return any metrics. Maybe the server got disconnected ? Trying to reconnect.");
            _instances.remove(instance);
            Instance newInstance = new Instance(instance.getYaml(), instance.getInitConfig(), instance.getCheckName(), config);
            try {
                LOGGER.info("Trying to reconnecting to: " + newInstance);
                newInstance.init(true);
                _instances.add(newInstance);
                it.remove();
            }
            catch (IOException e) {
                warning = "Cannot connect to instance " + instance + ". Is a JMX Server running at this address?";
                LOGGER.warn(warning);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
            }
            catch (SecurityException e) {
                warning = "Cannot connect to instance " + instance + " because of bad credentials. Please check your credentials";
                LOGGER.warn(warning);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
            }
            catch (FailedLoginException e) {
                warning = "Cannot connect to instance " + instance + " because of bad credentials. Please check your credentials";
                LOGGER.warn(warning);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
            }
            catch (Exception e) {
                warning = "Cannot connect to instance " + instance + " for an unknown reason." + e.getMessage();
                LOGGER.fatal(warning, e);
                config.status.addInstanceStats(instance.getCheckName(), instance.getName(), 0, warning, "ERROR");
            }
        }
        try {
            config.status.flush();
        }
        catch (Exception e) {
            LOGGER.error("Unable to flush stats.", e);
        }
    }

    private static HashMap<String, YamlParser> _getConfigs(AppConfig config) {
        HashMap<String, YamlParser> configs = new HashMap<String, YamlParser>();
        for (String fileName : config.yamlFileList) {
            File f = new File(config.confdDirectory, fileName);
            String name = f.getName().replace(".yaml", "");
            try {
                LOGGER.info("Reading " + f.getAbsolutePath());
                YamlParser fileConfig = new YamlParser(f.getAbsolutePath());
                configs.put(name, fileConfig);
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Cannot find " + f.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse yaml file " + f.getAbsolutePath(), e);
            }
        }
        LOGGER.info("Found " + configs.size() + " config files");
        return configs;
    }

    public static void init(AppConfig config, boolean forceNewConnection) {
        _brokenInstances = new LinkedList();
        _instances = new ArrayList();
        HashMap<String, YamlParser> configs = App._getConfigs(config);
        Iterator<Map.Entry<String, YamlParser>> it = configs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, YamlParser> entry = it.next();
            String name = entry.getKey();
            YamlParser yamlConfig = entry.getValue();
            it.remove();
            ArrayList configInstances = (ArrayList)yamlConfig.getYamlInstances();
            if (configInstances == null || configInstances.size() == 0) {
                String warning = "No instance found in :" + name;
                LOGGER.warn(warning);
                config.status.addInitFailedCheck(name, warning, "ERROR");
                continue;
            }
            Iterator i = configInstances.iterator();
            while (i.hasNext()) {
                String warning;
                Instance instance = null;
                try {
                    instance = new Instance((LinkedHashMap)i.next(), (LinkedHashMap)yamlConfig.getInitConfig(), name, config);
                }
                catch (Exception e) {
                    warning = "Unable to create instance. Please check your yaml file";
                    config.status.addInitFailedCheck(name, warning, "ERROR");
                    LOGGER.error(warning);
                    continue;
                }
                try {
                    instance.init(forceNewConnection);
                    _instances.add(instance);
                }
                catch (IOException e) {
                    _brokenInstances.add(instance);
                    warning = "Cannot connect to instance " + instance + " " + e.getMessage();
                    config.status.addInstanceStats(name, instance.getName(), 0, warning, "ERROR");
                    LOGGER.error(warning);
                }
                catch (Exception e) {
                    _brokenInstances.add(instance);
                    warning = "Unexpected exception while initiating instance " + instance + " : " + e.getMessage();
                    config.status.addInstanceStats(name, instance.getName(), 0, warning, "ERROR");
                    LOGGER.error(warning, e);
                }
            }
        }
    }

    public static int getLoopCounter() {
        return _loopCounter;
    }
}

