# Copyright 2017 FUJITSU LIMITED
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import re

from hacking import core

assert_no_xrange_re = re.compile(r"\s*xrange\s*\(")


@core.flake8ext
def no_xrange(logical_line):
    """Do not use 'xrange'
    B319
    """
    if assert_no_xrange_re.match(logical_line):
        yield (0, "B319: Do not use xrange().")
