# Copyright 2015 FUJITSU LIMITED
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from oslo_config import cfg

service_available_group = cfg.OptGroup(name='service_available',
                                       title='Available OpenStack Services')
ServiceAvailableGroup = [
    cfg.BoolOpt('logs',
                default=True,
                help=('Whether or not Monasca-Log-Api '
                      'is expected to be available')),
    cfg.BoolOpt('logs-search',
                default=True,
                help=('Whether or not Monasca-Log-Api search engine '
                      '(ElasticSearch) is expected to be available')),
]

monitoring_group = cfg.OptGroup(name='monitoring',
                                title='Monitoring Service Options')
MonitoringGroup = [
    cfg.StrOpt('api_version',
               default='v2.0',
               help='monasca-log-api API version'),
]

IdentityGroup = [
    cfg.StrOpt('kibana_version',
               default='4.4.0',
               help='Kibana version')
]

cfg.CONF.register_opts(IdentityGroup, group='identity')
