# Copyright 2012 Managed I.T.
#
# Author: Kiall Mac Innes <kiall@managedit.ie>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
from designate.openstack.common import cfg
from designate.openstack.common import log as logging
from designate.storage.base import Storage

LOG = logging.getLogger(__name__)


def get_storage():
    """ Return the engine class from the provided engine name """
    storage_driver = cfg.CONF['service:central'].storage_driver
    return Storage.get_plugin(storage_driver, invoke_on_load=True)


def setup_schema():
    """ Create the DB - Used for testing purposes """
    LOG.debug("Setting up Schema")
    storage = get_storage()
    storage.setup_schema()


def teardown_schema():
    """ Reset the DB to default - Used for testing purposes """
    LOG.debug("Tearing down Schema")
    storage = get_storage()
    storage.teardown_schema()
