# Copyright 2016 Huawei Technologies Co.,LTD.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_config import cfg

from mogan.common import rpc
from mogan import version


def parse_args(argv, default_config_files=None):
    rpc.set_defaults(control_exchange='mogan')
    cfg.CONF(argv[1:],
             project='mogan',
             version=version.version_info.release_string(),
             default_config_files=default_config_files)
    rpc.init(cfg.CONF)
