# Generated by confd

function osh_filters ()
{
  # support any addresses matching our secondary announcements
{{- range .Values.networking.bgp.ipv4.additional_cidrs }}
  if ( net ~ {{ . }} ) then { accept; }
{{- end }}
}

function apply_communities ()
{
  # Set community value based on dictionary of cidrs
{{- $asnum := .Values.networking.bgp.asnumber }}
{{- range .Values.networking.bgp.ipv4.community_cidr_ref }}
  {{- $community := .community }}
  {{- $cidr := .cidr }}
  {{- with .prefix }}
  if ( net ~ {{ $cidr }} ) then { bgp_community.add(({{ . }}, {{ $community }})); }
  {{- else }}
  if ( net ~ {{ $cidr }} ) then { bgp_community.add(({{ $asnum }}, {{ $community }})); }
  {{- end }}
{{- end }}
}

filter calico_pools {
  apply_communities();
  calico_aggr();
  osh_filters();
{{`{{range ls "/v1/ipam/v4/pool"}}{{$data := json (getv (printf "/v1/ipam/v4/pool/%s" .))}}`}}
{{`  if ( net ~ {{$data.cidr}} ) then {`}}
    accept;
  }
{{`{{end}}`}}
  reject;
}

{{`{{$network_key := printf "/bgp/v1/host/%s/network_v4" (getenv "NODENAME")}}{{if exists $network_key}}{{$network := getv $network_key}}`}}
filter calico_ipip {
{{`{{range ls "/v1/ipam/v4/pool"}}{{$data := json (getv (printf "/v1/ipam/v4/pool/%s" .))}}`}}
{{`  if ( net ~ {{$data.cidr}} ) then {`}}
{{`{{if $data.ipip_mode}}{{if eq $data.ipip_mode "cross-subnet"}}`}}
{{`    if defined(bgp_next_hop) && ( bgp_next_hop ~ {{$network}} ) then`}}
{{`      krt_tunnel = "";                     {{/* Destination in ipPool, mode is cross sub-net, route from-host on subnet, do not use IPIP */}}`}}
    else
{{`      krt_tunnel = "{{$data.ipip}}";       {{/* Destination in ipPool, mode is cross sub-net, route from-host off subnet, set the tunnel (if IPIP not enabled, value will be "") */}}`}}
    accept;
{{`  } {{else}}`}}
{{`    krt_tunnel = "{{$data.ipip}}";         {{/* Destination in ipPool, mode not cross sub-net, set the tunnel (if IPIP not enabled, value will be "") */}}`}}
    accept;
{{`  } {{end}} {{else}}`}}
{{`    krt_tunnel = "{{$data.ipip}}";         {{/* Destination in ipPool, mode field is not present, set the tunnel (if IPIP not enabled, value will be "") */}}`}}
    accept;
{{`  } {{end}}`}}
{{`{{end}}`}}
{{`  accept;                                  {{/* Destination is not in any ipPool, accept  */}}`}}
}
{{`{{else}}`}}
filter calico_ipip { accept; }
{{`{{end}}{{/* End of 'exists $network_key' */}}`}}
