# Generated by confd

function osh_filters ()
{
  # support any addresses matching our secondary announcements
{{- range .Values.networking.bgp.ipv6.additional_cidrs }}
  if ( net ~ {{ . }} ) then { accept; }
{{- end }}
}

function apply_communities ()
{
  # Set community value based on dictionary of cidrs
{{- $asnum := .Values.networking.bgp.asnumber }}
{{- range .Values.networking.bgp.ipv6.community_cidr_ref }}
  {{- $community := .community }}
  {{- $cidr := .cidr }}
  {{- with .prefix }}
  if ( net ~ {{ $cidr }} ) then { bgp_community.add(({{ . }}, {{ $community }})); }
  {{- else }}
  if ( net ~ {{ $cidr }} ) then { bgp_community.add(({{ $asnum }}, {{ $community }})); }
  {{- end }}
{{- end }}
}

filter calico_pools {
  apply_communities();
  calico_aggr();
  osh_filters();
{{`{{range ls "/pool"}}{{$data := json (getv (printf "/pool/%s" .))}}`}}
{{`  if ( net ~ {{$data.cidr}} ) then {`}}
    accept;
  }
{{`{{end}}`}}
  reject;
}
