# Release notes

## 2025.2.0-27

- Fixes typos for driver agent mounts in helm templates
- Add helm hook annotations in jobs by default.

## 2025.2.0

- Directly use module for Octavia API UWSGI as WSGI script octavia-wsgi has
  removed from Octavia.
- Run driver agent as a separate deployment on network nodes
- Run worker as a daemonset instead of deployment on network nodes
- Worker daemonset creates an interface attached to the
  Octavia management network to get access to amphora instances
- Set octavia-health-manager pods to run on openstack-network-node
  nodes in order to access the ovs socket and perform ovs functions.
- Fix containerPort and readiness/liveness probe port of octavia-api.
- Adjust default container images to 2024.1 like other applications in OpenStack
  Helm instead of an out of date container.
- Move healthcheck endpoint path to the proper values section
- Fixes octavia-api custom volume mounts inadvertently removed in
  https://review.opendev.org/c/openstack/openstack-helm/+/953481
- Allow for rbac customization of octavia policy.yaml by including
  a policy.yaml file.
- Unhardcode readiness of octavia-api and add liveness probe. Also healthcheck of
  octavia is enabled.
- Health manager requires NET_RAW and NET_BIND_SERVICE for allowing ISC DHCPD to work

### New Features

- Update apparmor values to use security_context instead of annotations.
- Add support for runtimeClassName and priorityClassName

## 2025.1.0

## 2024.2.0

Before 2024.2.0 all the OpenStack-Helm charts were versioned independently.
Here we provide all the release notes for the chart for all versions before 2024.2.0.

- 0.1.0 Initial Chart
- 0.1.1 Change helm-toolkit dependency version to ">= 0.1.0"
- 0.1.2 Added post-install and post-upgrade hook for Jobs
- 0.2.0 Remove support for releases before T
- 0.2.1 Fix dnsPolicy for housekeeping service
- 0.2.2 Update htk requirements repo
- 0.2.3 Allow using log_config_append=null
- 0.2.4 Fix transport_url
- 0.2.5 Migrated PodDisruptionBudget resource to policy/v1 API version
- 0.2.6 Added OCI registry authentication
- 0.2.7 Use HTTP probe instead of TCP probe
- 0.2.8 Define service_type in keystone_authtoken to support application credentials with access rules
- 0.2.9 Use default timeout and retry configs for haproxy_amphora
- 0.2.10 Fix generating health_manager Role and RoleBinding
- 0.2.11 Uses uWSGI for API service
- 0.2.12 Enable custom annotations for Openstack pods
- 0.2.13 Enable custom annotations for Openstack secrets
- 0.2.14 Update images used by default
- 0.2.15 Use quay.io/airshipit/kubernetes-entrypoint:latest-ubuntu_focal by default
- 0.2.16 Update Chart.yaml apiVersion to v2
- 2024.2.0 Update version to align with the Openstack release cycle
