# Release notes

## 2025.2.0-104

- Introduce .Values.openvswitch.extraContainers hook to make it possible to
  add extra containers to openvswitch daemonset, e.g. for monitoring
  purposes.
- Add missing priority class and runtime class definition for openvswitch
- Added /var/tmp mount to ovs-vswitchd container.
  This change ensures proper operation when using DPDK with the Mellanox driver.

### New Features

- Update default ingress classes and annotations for charts to make them implementation
  agnostic. They used to be nginx specific because we always used ingress-nginx as the most
  common choice. Ingress-nginx is deprecated and will become unmaintained in Feb/2026.
  
  Now for all test jobs we use HAProxy Ingress as the default implementation. However any
  other implementation can be used as far as it suppports annotations similar to
  'nginx.ingress.kubernetes.io/rewrite-target' or 'haproxy.org/path-rewrite' which are
  used in many OpenStack-Helm charts.
- Added an extraObjects list to every chart to allow for adding extra
  Kubernetes objects along side the chart without modifying the chart.
  It has the added benefit of using Helm's built in templating so
  you are able to utilize other values supplied to the chart.
- Added emptyDir mounted at /var/lock and set OSLO_LOCK_PATH env var to
  this path for oslo.concurrency support in all OpenStack services.
- Add ability to override cpuset.mems and cpuset.cpus for osh-openvswitch
  cgroup.

### Upgrade Notes

- Support for Helm 2 has been removed by removal of the helm3_hook value across all charts.
  It is no longer possible to set helm3_hook to False to support Helm 2.

## 2025.2.0

### New Features

- Update apparmor values to use security_context instead of annotations.
- Add support for runtimeClassName and priorityClassName

## 2025.1.0

- Change Open vSwitch to run with non-root user
- Set nova user as owner for hugepages mount path
- Make the --user flag for OVS server optional
- 0.1.0 Initial Chart
- 0.1.1 Change helm-toolkit dependency version to ">= 0.1.0"
- 0.1.2 Unpin images built with osh-images
- 0.1.3 Use HostToContainer mountPropagation
- 0.1.4 Support override of vswitchd liveness and readiness probe
- 0.1.5 Use full image ref for docker official images
- 0.1.6 Update htk requirements
- 0.1.7 Enable taint toleration for Openstack services jobs
- 0.1.8 Added OCI registry authentication
- 0.1.9 Enable ovs hardware offload
- 0.1.10 Merge ovs-db and ovs-vswitchd in one Daemonset
- 0.1.11 Add ovn.yaml in values_override, Enable ptcp_port 6640 which needed when use ovn
- 0.1.12 Replace node-role.kubernetes.io/master with control-plane
- 0.1.13 Upgrade openvswitch image to latest-ubuntu_focal to fix qos issue
- 0.1.14 Add buffer before accesses pid file
- 0.1.15 Add buffer before accesses ovs controller pid socket
- 0.1.16 Restore ServiceAccount to openvswitch pod
- 0.1.17 Add buffer to wait for potential new CTL file before running chown
- 0.1.18 Add value for extra poststart command
- 0.1.19 Add check for cgroups v2 file structure
- 0.1.20 Add Ubuntu Focal and Ubuntu Jammy overrides
- 0.1.21 Add overrides for dpdk
- 0.1.22 Change hugepages size to 2M for easier configuration
- 0.1.23 Fix rolebinding for init container
- 0.1.24 Change ovs to run as child process of start script
- 0.1.25 Use quay.io/airshipit/kubernetes-entrypoint:latest-ubuntu_focal by default
- 0.1.26 Update Chart.yaml apiVersion to v2
- 2024.2.0 Update version to align with the Openstack release cycle

## 2024.2.0

Before 2024.2.0 all the OpenStack-Helm charts were versioned independently.
Here we provide all the release notes for the chart for all versions before 2024.2.0.
