{{/*
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/}}

{{- define "swift.bin.container_start" }}
#!/bin/bash
set -ex

export HOME=/tmp

# Wait for ring files
echo "Waiting for container ring file..."
while [ ! -f /etc/swift/container.ring.gz ]; do
    echo "Container ring file not found, waiting..."
    sleep 5
done

echo "Container ring file found"

# Create required directories
mkdir -p /var/cache/swift /var/run/swift /var/log/swift /var/lock

# Set permissions
chown -R swift:swift /etc/swift /srv/node /var/cache/swift /var/run/swift /var/log/swift /var/lock 2>/dev/null || true

# Start container services
echo "Starting container services..."
swift-container-server /etc/swift/container-server.conf &
swift-container-auditor /etc/swift/container-server.conf &
swift-container-replicator /etc/swift/container-server.conf &
swift-container-updater /etc/swift/container-server.conf &
swift-container-sync /etc/swift/container-server.conf &

echo "Swift container services started"

# Wait for any process to exit
wait
{{- end }}
