# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2012, Red Hat, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from openstack.common import excutils
from tests import utils


class SaveAndReraiseTest(utils.BaseTestCase):

    def test_save_and_reraise_exception(self):
        e = None
        msg = 'foo'
        try:
            try:
                raise Exception(msg)
            except:
                with excutils.save_and_reraise_exception():
                    pass
        except Exception, _e:
            e = _e

        self.assertEqual(str(e), msg)

    def test_save_and_reraise_exception_dropped(self):
        e = None
        msg = 'second exception'
        try:
            try:
                raise Exception('dropped')
            except:
                with excutils.save_and_reraise_exception():
                    raise Exception(msg)
        except Exception, _e:
            e = _e

        self.assertEqual(str(e), msg)
