#    Copyright 2015 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

require 'spec_helper'

describe "lma_collector::logs::openstack" do
    let(:facts) do
        {:kernel => 'Linux', :operatingsystem => 'Ubuntu',
         :osfamily => 'Debian'}
    end

    describe "with title" do
        let(:title) { :nova }
        it { is_expected.to contain_heka__input__logstreamer('nova') \
             .with_differentiator("['nova', '_', 'Service']") \
             .with_file_match('(?P<Service>.+)\.log\.?(?P<Seq>\d*)$')
        }
    end
    describe "with title and service_match" do
        let(:title) { :nova }
        let(:params) do
          { :service_match => '(dhcp-agent|l3-agent|metadata-agent|neutron-netns-cleanup|openvswitch-agent|server)' }
        end

        it { is_expected.to contain_heka__input__logstreamer('nova') \
             .with_file_match('(?P<Service>(dhcp-agent|l3-agent|metadata-agent|neutron-netns-cleanup|openvswitch-agent|server))\.log\.?(?P<Seq>\d*)$')
        }
    end
end
