require 'spec_helper'

describe 'collectd' do

 let :facts do
   {:osfamily => 'RedHat'}
 end

 it { should contain_package('collectd').with(
   :ensure => 'installed'
 )}

 it { should contain_service('collectd').with(
   :ensure => 'running'
 )}

 it { should contain_file('collectd.conf').with(
  :content => nil
 )}

 it { should contain_file('collectd.d').with(
  :ensure => 'directory'
 )}

  it { should contain_file_line('include_conf_d') }

 context 'on non supported operating systems' do
   let :facts do
     {:osfamily => 'foo'}
   end

   it 'should fail' do
     should compile.and_raise_error(/foo is not supported/)
   end
 end

 context 'when purge_config is enabled' do
   let :params do
     { :purge_config => true }
   end
   it { should contain_file('collectd.conf').with_content(
    /^# Generated by Puppet$/
   )}
   it { should_not contain_file_line('include_conf_d') }
 end

 context 'when custom package_name is set' do
   let :params do
     { :package_name => 'collectd-core' }
   end

   it { should contain_package('collectd-core').with(
     :ensure => 'installed'
   )}
 end

end
