#
#  Copyright (C) 2016 Red Hat, Inc.
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
require 'spec_helper'

describe 'ceph::profile::fs' do

  shared_examples 'ceph profile fs' do

    it { should contain_ceph__fs('fs_name').with(
      'metadata_pool' => 'metadata_pool',
      'data_pool' => 'data_pool'
    )}
  end

  on_supported_os.each do |os, facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge!(OSDefaults.get_facts({:hostname => 'myhostname'}))
      end

      it_behaves_like 'ceph profile fs'
    end
  end
end
