require 'spec_helper'

describe 'keystone::db::postgresql' do

  shared_examples_for 'keystone::db::postgresql' do
    let :req_params do
      { :password => 'pw' }
    end

    let :pre_condition do
      'include postgresql::server'
    end

    context 'with only required parameters' do
      let :params do
        req_params
      end

      it { is_expected.to contain_postgresql__server__db('keystone').with(
        :user     => 'keystone',
        :password => 'md5c530c33636c58ae83ca933f39319273e'
      )}
    end

  end

  on_supported_os({
    :supported_os   => OSDefaults.get_supported_os
  }).each do |os,facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge(OSDefaults.get_facts({
          :os_workers_keystone => 8,
          :concat_basedir      => '/var/lib/puppet/concat'
        }))
      end

      it_configures 'keystone::db::postgresql'
    end
  end

end
