require 'spec_helper'

describe 'murano::db::sync_cfapi' do

  shared_examples_for 'murano-dbsync-cfapi' do

    it 'runs murano-cfapi-dbmanage' do
      is_expected.to contain_exec('murano-cfapi-dbmanage').with(
        :command     => 'murano-cfapi-db-manage --config-file /etc/murano/murano-cfapi.conf upgrade',
        :path        => '/usr/bin',
        :user        => 'murano_cfapi',
        :refreshonly => 'true',
        :logoutput   => 'on_failure'
      )
    end

  end

  on_supported_os({
    :supported_os   => OSDefaults.get_supported_os
  }).each do |os,facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge(OSDefaults.get_facts({
          :concat_basedir => '/var/lib/puppet/concat'
        }))
      end

      it_configures 'murano-dbsync-cfapi'
    end
  end

end
