require 'spec_helper'

describe 'neutron::policy' do
  shared_examples 'neutron policies' do
    let :params do
      {
        :policy_path => '/etc/neutron/policy.yaml',
        :policies    => {
          'context_is_admin' => {
            'key'   => 'context_is_admin',
            'value' => 'foo:bar'
          }
        }
      }
    end

    it 'set up the policies' do
      should contain_openstacklib__policy__base('context_is_admin').with({
        :key         => 'context_is_admin',
        :value       => 'foo:bar',
        :file_user   => 'root',
        :file_group  => 'neutron',
        :file_format => 'yaml',
      })
      should contain_oslo__policy('neutron_config').with(
        :policy_file => '/etc/neutron/policy.yaml',
      )
    end
  end

  on_supported_os({
    :supported_os   => OSDefaults.get_supported_os
  }).each do |os,facts|
    context "on #{os}" do
      let (:facts) do
        facts.merge!(OSDefaults.get_facts())
      end

      it_behaves_like 'neutron policies'
    end
  end
end
