# == Define: pacemaker::stonith::fence_kdump
#
# Module for managing Stonith for fence_kdump.
#
# WARNING: Generated by "rake generate_stonith", manual changes will
# be lost.
#
# === Parameters
#
# [*nodename*]
#   Name or IP address of node to be fenced
#
# [*ipport*]
#   Port number
#
# [*family*]
#   Network family
#
# [*action*]
#   Fencing action
#
# [*timeout*]
#   Timeout in seconds
#
# [*verbose*]
#   Print verbose output
#
# [*usage*]
#   Print usage
#
#  [*interval*]
#   Interval between tries.
#
# [*ensure*]
#   The desired state of the resource.
#
# [*tries*]
#   The numbre of tries.
#
# [*try_sleep*]
#   Time to sleep between tries.
#
# [*pcmk_host_list*]
#   List of Pacemaker hosts.
#
# === Dependencies
#  None
#
# === Authors
#
# Generated by rake generate_stonith task.
#
# === Copyright
#
# Copyright (C) 2016 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
define pacemaker::stonith::fence_kdump (
  $nodename       = undef,
  $ipport         = undef,
  $family         = undef,
  $action         = undef,
  $timeout        = undef,
  $verbose        = undef,
  $usage          = undef,

  $interval       = '60s',
  $ensure         = present,
  $pcmk_host_list = undef,

  $tries          = undef,
  $try_sleep      = undef,

) {
  $nodename_chunk = $nodename ? {
    undef   => '',
    default => "nodename=\"${nodename}\"",
  }
  $ipport_chunk = $ipport ? {
    undef   => '',
    default => "ipport=\"${ipport}\"",
  }
  $family_chunk = $family ? {
    undef   => '',
    default => "family=\"${family}\"",
  }
  $action_chunk = $action ? {
    undef   => '',
    default => "action=\"${action}\"",
  }
  $timeout_chunk = $timeout ? {
    undef   => '',
    default => "timeout=\"${timeout}\"",
  }
  $verbose_chunk = $verbose ? {
    undef   => '',
    default => "verbose=\"${verbose}\"",
  }
  $usage_chunk = $usage ? {
    undef   => '',
    default => "usage=\"${usage}\"",
  }

  $pcmk_host_value_chunk = $pcmk_host_list ? {
    undef   => '$(/usr/sbin/crm_node -n)',
    default => $pcmk_host_list,
  }

  # $title can be a mac address, remove the colons for pcmk resource name
  $safe_title = regsubst($title, ':', '', 'G')

  # On Pacemaker Remote nodes we don't want a full corosync
  $pcmk_require = str2bool($::pcmk_is_remote) ? { true => [], false => Class['pacemaker::corosync'] }

  if($ensure == absent) {
    exec { "Delete stonith-fence_kdump-${safe_title}":
      command => "/usr/sbin/pcs stonith delete stonith-fence_kdump-${safe_title}",
      onlyif  => "/usr/sbin/pcs stonith show stonith-fence_kdump-${safe_title} > /dev/null 2>&1",
      require => $pcmk_require,
    }
  } else {
    package {
      'fence-agents-kdump': ensure => installed,
    } ->
    exec { "Create stonith-fence_kdump-${safe_title}":
      command   => "/usr/sbin/pcs stonith create stonith-fence_kdump-${safe_title} fence_kdump pcmk_host_list=\"${pcmk_host_value_chunk}\" ${nodename_chunk} ${ipport_chunk} ${family_chunk} ${action_chunk} ${timeout_chunk} ${verbose_chunk} ${usage_chunk}  op monitor interval=${interval}",
      unless    => "/usr/sbin/pcs stonith show stonith-fence_kdump-${safe_title} > /dev/null 2>&1",
      tries     => $tries,
      try_sleep => $try_sleep,
      require   => $pcmk_require,
    } ~>
    exec { "Add non-local constraint for stonith-fence_kdump-${safe_title}":
      command     => "/usr/sbin/pcs constraint location stonith-fence_kdump-${safe_title} avoids ${pcmk_host_value_chunk}",
      tries       => $tries,
      try_sleep   => $try_sleep,
      refreshonly => true,
    }
  }
}
