# == Define: pacemaker::stonith::fence_virt
#
# Module for managing Stonith for fence_virt.
#
# WARNING: Generated by "rake generate_stonith", manual changes will
# be lost.
#
# === Parameters
#
# [*debug*]
#   Specify (stdin) or increment (command line) debug level
#
# [*serial_device*]
#   Serial device (default=/dev/ttyS1)
#
# [*serial_params*]
#   Serial Parameters (default=115200,8N1)
#
# [*channel_address*]
#   VM Channel IP address (default=10.0.2.179)
#
# [*ipport*]
#   Multicast or VMChannel IP port (default=1229)
#
# [*port*]
#   Virtual Machine (domain name) to fence
#
# [*action*]
#   Fencing action (null, off, on, [reboot], status, list, monitor, metadata)
#
# [*timeout*]
#   Fencing timeout (in seconds; default=30)
#
# [*delay*]
#   Fencing delay (in seconds; default=0)
#
# [*domain*]
#   Virtual Machine (domain name) to fence (deprecated; use port)
#
#  [*interval*]
#   Interval between tries.
#
# [*ensure*]
#   The desired state of the resource.
#
# [*tries*]
#   The numbre of tries.
#
# [*try_sleep*]
#   Time to sleep between tries.
#
# [*pcmk_host_list*]
#   List of Pacemaker hosts.
#
# === Dependencies
#  None
#
# === Authors
#
# Generated by rake generate_stonith task.
#
# === Copyright
#
# Copyright (C) 2016 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
define pacemaker::stonith::fence_virt (
  $debug           = undef,
  $serial_device   = undef,
  $serial_params   = undef,
  $channel_address = undef,
  $ipport          = undef,
  $port            = undef,
  $action          = undef,
  $timeout         = undef,
  $delay           = undef,
  $domain          = undef,

  $interval        = '60s',
  $ensure          = present,
  $pcmk_host_list  = undef,

  $tries           = undef,
  $try_sleep       = undef,

) {
  $debug_chunk = $debug ? {
    undef   => '',
    default => "debug=\"${debug}\"",
  }
  $serial_device_chunk = $serial_device ? {
    undef   => '',
    default => "serial_device=\"${serial_device}\"",
  }
  $serial_params_chunk = $serial_params ? {
    undef   => '',
    default => "serial_params=\"${serial_params}\"",
  }
  $channel_address_chunk = $channel_address ? {
    undef   => '',
    default => "channel_address=\"${channel_address}\"",
  }
  $ipport_chunk = $ipport ? {
    undef   => '',
    default => "ipport=\"${ipport}\"",
  }
  $port_chunk = $port ? {
    undef   => '',
    default => "port=\"${port}\"",
  }
  $action_chunk = $action ? {
    undef   => '',
    default => "action=\"${action}\"",
  }
  $timeout_chunk = $timeout ? {
    undef   => '',
    default => "timeout=\"${timeout}\"",
  }
  $delay_chunk = $delay ? {
    undef   => '',
    default => "delay=\"${delay}\"",
  }
  $domain_chunk = $domain ? {
    undef   => '',
    default => "domain=\"${domain}\"",
  }

  $pcmk_host_value_chunk = $pcmk_host_list ? {
    undef   => '$(/usr/sbin/crm_node -n)',
    default => $pcmk_host_list,
  }

  # $title can be a mac address, remove the colons for pcmk resource name
  $safe_title = regsubst($title, ':', '', 'G')

  # On Pacemaker Remote nodes we don't want a full corosync
  $pcmk_require = str2bool($::pcmk_is_remote) ? { true => [], false => Class['pacemaker::corosync'] }

  if($ensure == absent) {
    exec { "Delete stonith-fence_virt-${safe_title}":
      command => "/usr/sbin/pcs stonith delete stonith-fence_virt-${safe_title}",
      onlyif  => "/usr/sbin/pcs stonith show stonith-fence_virt-${safe_title} > /dev/null 2>&1",
      require => $pcmk_require,
    }
  } else {
    package {
      'fence-virt': ensure => installed,
    } ->
    exec { "Create stonith-fence_virt-${safe_title}":
      command   => "/usr/sbin/pcs stonith create stonith-fence_virt-${safe_title} fence_virt pcmk_host_list=\"${pcmk_host_value_chunk}\" ${debug_chunk} ${serial_device_chunk} ${serial_params_chunk} ${channel_address_chunk} ${ipport_chunk} ${port_chunk} ${action_chunk} ${timeout_chunk} ${delay_chunk} ${domain_chunk}  op monitor interval=${interval}",
      unless    => "/usr/sbin/pcs stonith show stonith-fence_virt-${safe_title} > /dev/null 2>&1",
      tries     => $tries,
      try_sleep => $try_sleep,
      require   => $pcmk_require,
    } ~>
    exec { "Add non-local constraint for stonith-fence_virt-${safe_title}":
      command     => "/usr/sbin/pcs constraint location stonith-fence_virt-${safe_title} avoids ${pcmk_host_value_chunk}",
      tries       => $tries,
      try_sleep   => $try_sleep,
      refreshonly => true,
    }
  }
}
