# == Define: pacemaker::stonith::fence_watchdog
#
# Module for managing Stonith for fence_watchdog.
#
# WARNING: Generated by "rake generate_stonith", manual changes will
# be lost.
#
# === Parameters
#
# [*action*]
#   Fencing Action
#
# [*nodename*]
#   Ignored
#
# [*plug*]
#   Ignored
#
#  [*interval*]
#   Interval between tries.
#
# [*ensure*]
#   The desired state of the resource.
#
# [*tries*]
#   The number of tries.
#
# [*try_sleep*]
#   Time to sleep between tries.
#
# [*pcmk_host_list*]
#   List of Pacemaker hosts.
#
# [*meta_attr*]
#   (optional) String of meta attributes
#   Defaults to undef
#
# [*deep_compare*]
#   Enable deep comparing of resources and bundles
#   When set to true a resource will be compared in full (options, meta parameters,..)
#   to the existing one and in case of difference it will be repushed to the CIB
#   Defaults to false
#
# [*update_settle_secs*]
#   When deep_compare is enabled and puppet updates a resource, this
#   parameter represents the number (in seconds) to wait for the cluster to settle
#   after the resource update.
#   Defaults to 600 (seconds)
#
# === Dependencies
#  None
#
# === Authors
#
# Generated by rake generate_stonith task.
#
# === Copyright
#
# Copyright (C) 2016 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
define pacemaker::stonith::fence_watchdog (
  $action         = undef,
  $nodename       = undef,
  $plug           = undef,

  $meta_attr      = undef,
  $interval       = '60s',
  $ensure         = present,
  $pcmk_host_list = undef,

  $tries          = undef,
  $try_sleep      = undef,

  $deep_compare       = false,
  $update_settle_secs = 600,
) {
  $action_chunk = $action ? {
    undef   => '',
    default => "action=\"${action}\"",
  }
  $nodename_chunk = $nodename ? {
    undef   => '',
    default => "nodename=\"${nodename}\"",
  }
  $plug_chunk = $plug ? {
    undef   => '',
    default => "plug=\"${plug}\"",
  }

  $pcmk_host_value_chunk = '$(crm_node -l |awk \'{print $2}\' |paste -sd, -)'

  $meta_attr_value_chunk = $meta_attr ? {
    undef   => '',
    default => "meta ${meta_attr}",
  }

  # $title can be a mac address, remove the colons for pcmk resource name
  $safe_title = regsubst($title, ':', '', 'G')

  Exec<| title == 'wait-for-settle' |> -> Pcmk_stonith<||>

  $param_string = "${action_chunk} ${nodename_chunk} ${plug_chunk}  op monitor interval=${interval} ${meta_attr_value_chunk}"

  if $ensure != 'absent' {
    ensure_packages('fence-agents-sbd', { ensure => 'installed' })
    Package['fence-agents-sbd'] -> Pcmk_stonith['watchdog']
  }
  pcmk_stonith { 'watchdog':
    ensure             => $ensure,
    stonith_type       => 'fence_watchdog',
    pcmk_host_list     => $pcmk_host_value_chunk,
    pcs_param_string   => $param_string,
    tries              => $tries,
    try_sleep          => $try_sleep,
    deep_compare       => $deep_compare,
    update_settle_secs => $update_settle_secs,
  }
}
