#
# Copyright (C) 2019 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#

require 'spec_helper'

describe 'tripleo::profile::base::glance::api' do
  shared_examples_for 'tripleo::profile::base::glance::api' do

    before :each do
      facts.merge!({ :step => params[:step] })
    end

    context 'with step less than 3' do
      let(:params) { {
        :step => 1,
      } }

      it {
        is_expected.to contain_class('tripleo::profile::base::glance::api')
        is_expected.to_not contain_class('glance')
        is_expected.to_not contain_class('glance::config')
        is_expected.to_not contain_class('glance::api::logging')
        is_expected.to_not contain_class('glance::api')
        is_expected.to_not contain_class('glance::notify::rabbitmq')
      }
    end

    context 'with step 3 on bootstrap node' do
      let(:params) { {
        :step                    => 3,
        :bootstrap_node          => 'node.example.com',
        :oslomsg_rpc_hosts       => [ '192.168.0.1' ],
        :oslomsg_rpc_username    => 'glance1',
        :oslomsg_rpc_password    => 'foo',
        :oslomsg_rpc_port        => '1234',
        :oslomsg_notify_hosts    => [ '192.168.0.2' ],
        :oslomsg_notify_username => 'glance2',
        :oslomsg_notify_password => 'baa',
        :oslomsg_notify_port     => '5678',
      } }

      it {
        is_expected.to contain_class('tripleo::profile::base::glance::api')
        is_expected.to contain_class('glance')
        is_expected.to contain_class('glance::config')
        is_expected.to contain_class('glance::api::logging')
        is_expected.to contain_class('glance::api')
        is_expected.to contain_class('glance::notify::rabbitmq').with(
          :default_transport_url      => 'rabbit://glance1:foo@192.168.0.1:1234/?ssl=0',
          :notification_transport_url => 'rabbit://glance2:baa@192.168.0.2:5678/?ssl=0',
        )
      }
    end

    context 'with step 3 not on bootstrap node' do
      let(:params) { {
        :step           => 3,
        :bootstrap_node => 'other.example.com',
      } }

      it {
        is_expected.to contain_class('tripleo::profile::base::glance::api')
        is_expected.to_not contain_class('glance')
        is_expected.to_not contain_class('glance::config')
        is_expected.to_not contain_class('glance::api::logging')
        is_expected.to_not contain_class('glance::api')
        is_expected.to_not contain_class('glance::notify::rabbitmq')
      }
    end

    context 'with step 4' do
      let(:params) { {
        :step                    => 4,
        :bootstrap_node          => 'node.example.com',
        :oslomsg_rpc_hosts       => [ '192.168.0.1' ],
        :oslomsg_rpc_username    => 'glance1',
        :oslomsg_rpc_password    => 'foo',
        :oslomsg_rpc_port        => '1234',
        :oslomsg_notify_hosts    => [ '192.168.0.2' ],
        :oslomsg_notify_username => 'glance2',
        :oslomsg_notify_password => 'baa',
        :oslomsg_notify_port     => '5678',
      } }

      it {
        is_expected.to contain_class('tripleo::profile::base::glance::api')
        is_expected.to contain_class('glance')
        is_expected.to contain_class('glance::config')
        is_expected.to contain_class('glance::api::logging')
        is_expected.to contain_class('glance::api')
        is_expected.to contain_class('glance::notify::rabbitmq').with(
          :default_transport_url      => 'rabbit://glance1:foo@192.168.0.1:1234/?ssl=0',
          :notification_transport_url => 'rabbit://glance2:baa@192.168.0.2:5678/?ssl=0',
        )
      }
    end

  end


  on_supported_os.each do |os, facts|
    context "on #{os}" do
      let(:facts) do
        facts.merge({ :hostname => 'node.example.com' })
      end

      it_behaves_like 'tripleo::profile::base::glance::api'
    end
  end
end
