# Copyright 2016 Red Hat, Inc.
# All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#
# == Class: tripleo::profile::base::sshd
#
# SSH profile for tripleo
#
# === Parameters
#
# [*bannertext*]
#   The text used within SSH Banner
#   Defaults to hiera('BannerText')
#
class tripleo::profile::base::sshd (
  $bannertext = hiera('BannerText', undef),
) {

  if $bannertext {
    $action = 'set'
  } else {
    $action = 'rm'
  }

  package {'openssh-server':
    ensure => installed,
  }

  augeas { 'sshd_config_banner':
    context => '/files/etc/ssh/sshd_config',
    changes => [ "${action} Banner /etc/issue"  ],
    notify  => Service['sshd']
  }

  file { '/etc/issue':
    ensure  => file,
    backup  => false,
    content => $bannertext,
    owner   => 'root',
    group   => 'root',
    mode    => '0600'
  }

  service { 'sshd':
    ensure    => 'running',
    enable    => true,
    hasstatus => false,
    require   => Package['openssh-server'],
  }
}
