# Copyright 2012 OpenStack LLC.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


class FakeAPI(object):
    def __init__(self, fixtures, strict_url_check=False):
        self.fixtures = fixtures
        self.calls = []
        self.strict_url_check = strict_url_check

    def _request(self, method, url, headers=None, body=None):
        call = (method, url, headers or {}, body)
        self.calls.append(call)
        if not self.strict_url_check:
            url = url.split('?', 1)[0]
        return self.fixtures[url][method]

    def raw_request(self, *args, **kwargs):
        return self._request(*args, **kwargs)

    def json_request(self, *args, **kwargs):
        return self._request(*args, **kwargs)
