#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

LOADBALANCER_RESOURCES = 'loadbalancers'
LISTENER_RESOURCES = 'listeners'
POOL_RESOURCES = 'pools'
MEMBER_RESOURCES = 'members'
HEALTH_MONITOR_RESOURCES = 'healthmonitors'
L7POLICY_RESOURCES = 'l7policies'
L7RULE_RESOURCES = 'rules'
QUOTA_RESOURCES = 'quotas'
AMPHORA_RESOURCES = 'amphorae'
PROVIDER_RESOURCES = 'providers'
PROVIDER_FLAVOR_CAPABILITY_RESOURCES = 'flavor_capabilities'
PROVIDER_AVAILABILITY_ZONE_CAPABILITY_RESOURCES = (
    'availability_zone_capabilities')
FLAVOR_RESOURCES = 'flavors'
FLAVORPROFILE_RESOURCES = 'flavorprofiles'
AVAILABILITYZONE_RESOURCES = 'availability_zones'
AVAILABILITYZONEPROFILE_RESOURCES = 'availability_zone_profiles'

BASE_LBAAS_ENDPOINT = '/lbaas'
BASE_OCTAVIA_ENDPOINT = '/octavia'

BASE_LOADBALANCER_URL = BASE_LBAAS_ENDPOINT + '/' + LOADBALANCER_RESOURCES
BASE_SINGLE_LB_URL = BASE_LOADBALANCER_URL + '/{uuid}'
BASE_LB_STATS_URL = BASE_SINGLE_LB_URL + '/stats'
BASE_LOADBALANCER_STATUS_URL = BASE_SINGLE_LB_URL + '/status'
BASE_LOADBALANCER_FAILOVER_URL = BASE_SINGLE_LB_URL + '/failover'

BASE_LISTENER_URL = BASE_LBAAS_ENDPOINT + '/' + LISTENER_RESOURCES
BASE_SINGLE_LISTENER_URL = BASE_LISTENER_URL + '/{uuid}'
BASE_LISTENER_STATS_URL = BASE_SINGLE_LISTENER_URL + '/stats'

BASE_POOL_URL = BASE_LBAAS_ENDPOINT + '/' + POOL_RESOURCES
BASE_SINGLE_POOL_URL = BASE_POOL_URL + '/{pool_id}'

BASE_MEMBER_URL = BASE_SINGLE_POOL_URL + '/' + MEMBER_RESOURCES
BASE_SINGLE_MEMBER_URL = BASE_MEMBER_URL + '/{member_id}'

BASE_HEALTH_MONITOR_URL = BASE_LBAAS_ENDPOINT + '/' + HEALTH_MONITOR_RESOURCES
BASE_SINGLE_HEALTH_MONITOR_URL = BASE_HEALTH_MONITOR_URL + '/{uuid}'

BASE_L7POLICY_URL = BASE_LBAAS_ENDPOINT + '/' + L7POLICY_RESOURCES
BASE_SINGLE_L7POLICY_URL = BASE_L7POLICY_URL + '/{policy_uuid}'
BASE_L7RULE_URL = BASE_SINGLE_L7POLICY_URL + '/' + L7RULE_RESOURCES
BASE_SINGLE_L7RULE_URL = BASE_L7RULE_URL + '/{rule_uuid}'

BASE_QUOTA_URL = BASE_LBAAS_ENDPOINT + '/' + QUOTA_RESOURCES
BASE_SINGLE_QUOTA_URL = BASE_QUOTA_URL + '/{uuid}'
BASE_QUOTA_DEFAULT_URL = BASE_QUOTA_URL + '/defaults'

BASE_AMPHORA_URL = BASE_OCTAVIA_ENDPOINT + "/" + AMPHORA_RESOURCES
BASE_SINGLE_AMPHORA_URL = BASE_AMPHORA_URL + "/{uuid}"
BASE_AMPHORA_CONFIGURE_URL = BASE_SINGLE_AMPHORA_URL + '/config'
BASE_AMPHORA_FAILOVER_URL = BASE_SINGLE_AMPHORA_URL + '/failover'

BASE_PROVIDER_URL = BASE_LBAAS_ENDPOINT + "/" + PROVIDER_RESOURCES
BASE_PROVIDER_FLAVOR_CAPABILITY_URL = (
    BASE_PROVIDER_URL + "/{provider}/" + PROVIDER_FLAVOR_CAPABILITY_RESOURCES)

BASE_FLAVOR_URL = BASE_LBAAS_ENDPOINT + "/" + FLAVOR_RESOURCES
BASE_SINGLE_FLAVOR_URL = BASE_FLAVOR_URL + "/{uuid}"
BASE_FLAVORPROFILE_URL = BASE_LBAAS_ENDPOINT + "/" + FLAVORPROFILE_RESOURCES
BASE_SINGLE_FLAVORPROFILE_URL = BASE_FLAVORPROFILE_URL + "/{uuid}"
