import re
import subprocess
import time
import uuid

import rally.vmprovider.provider as provider


class VirshProvider(provider.VMProviderFactory):

    def __init__(self, config):
        self._config = config

    def upload_image(self, image):
        raise NotImplemented()

    def destroy_image(self, image_uuid):
        raise NotImplemented()

    def create_vms(self, image_uuid=None, amount=1):
        """Create VMs with chosen image.
        :param image_uuid: Indetificator of image
        :param amount: amount of required VMs
        Returns list of VMs uuids.
        """
        vms = []
        for i in range(amount):
            vm_name = uuid.uuid4().hex
            vms.append(self.create_vm(vm_name))
        return vms

    def create_vm(self, vm_name):
        '''Clones prebuilt VM template and starts it
        '''
        virt_url = self._get_virt_connection_url(self._config['connection'])
        cmd = 'virt-clone --connect=%(url)s -o %(t)s -n %(n)s --auto-clone' % {
            't': self._config['template_name'],
            'n': vm_name,
            'url': virt_url
        }
        subprocess.check_call(cmd, shell=True)

        cmd = 'virsh --connect=%s start %s' % (virt_url, vm_name)
        subprocess.check_call(cmd, shell=True)

        return {
            'id': id,
            'name': vm_name,
            'ip': self._determine_vm_ip(vm_name),
        }

    def destroy_vms(self, vm_uuids):
        """Destroy already created vms by vm_uuids."""
        for vm in vm_uuids:
            self.destroy_vm(vm)

    def destroy_vm(self, vm):
        print('Destroy VM %s' % vm['name'])
        vconnection = self._get_virt_connection_url(self._config['connection'])

        cmd = 'virsh --connect=%s destroy %s' % (vconnection, vm['name'])
        subprocess.check_call(cmd, shell=True)
        cmd = 'virsh --connect=%s undefine %s --remove-all-storage' % (vconnection, vm['name'])
        subprocess.check_call(cmd, shell=True)
        return True

    @staticmethod
    def _get_virt_connection_url(connection):
        '''Formats QEMU connection string from SSH url
        '''
        return 'qemu+ssh://%s/system' % connection

    def _determine_vm_ip(self, vm_name):
        cmd = 'scp -o StrictHostKeyChecking=no ./get_domain_ip.sh %s:~/get_domain_ip.sh' % self._config['connection']
        subprocess.check_call(cmd, shell=True)

        tries = 0
        ip = None
        ip_regex = '^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'
        matcher = re.compile(ip_regex)
        while tries < 3 and not ip:
            cmd = 'ssh -o StrictHostKeyChecking=no %s ./get_domain_ip.sh %s' % (self._config['connection'], vm_name)
            out = subprocess.check_output(cmd, shell=True)
            match = matcher.search(out)
            if match:
                ip = match.group(0)
            tries += 1
            time.sleep(10)
        return str(ip)
