import eventlet.greenpool
import subprocess

import rally.deploy.engine as engine
import rally.vmprovider.providers.virsh as virsh


class DevstackDeployment(engine.EngineFactory):
    '''Deploys Devstack cloud.
    deploy config example:
        'deploy': {
            'connection': 'alex@performance-01',  # ssh connection to vms host
            'template_name': 'stack-01-devstack-template',  # vm image template
            'template_user': 'ubuntu'  # vm user to launch devstack
        },
    '''

    def __init__(self, config):
        self._config = config
        self._vms = []
        self._pool = eventlet.greenpool.GreenPool(10)
        self._vm_provider = virsh.VirshProvider(config)

    def deploy(self):
        self._vms = list(self._pool.imap(self._vm_provider.create_vm, range(1)))
        list(self._pool.imap(self.patch_devstack, self._vms))

        list(self._pool.imap(self.start_devstack, self._vms))
        return list(self._vms)

    def cleanup(self):
        list(self._pool.imap(self._vm_provider.destroy_vm, self._vms))

    def patch_devstack(self, vm):
        cmd = 'scp -o StrictHostKeyChecking=no ./devstack/localrc %s@%s:~/devstack/localrc' % (self._config['template_user'], vm['ip'])
        subprocess.check_call(cmd, shell=True)
        return True

    def start_devstack(self, vm):
        cmd = 'ssh -o StrictHostKeyChecking=no %s@%s devstack/stack.sh' % (self._config['template_user'], vm['ip'])
        subprocess.check_call(cmd, shell=True)
        return True
