# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2013: Mirantis Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from rally.benchmark.test_scenarios.nova import utils as nova_utils


class NovaServerMetadataTest(nova_utils.NovaTestCase):

    @classmethod
    def setUpClass(cls):
        super(NovaServerMetadataTest, cls).setUpClass()

    def setUp(self):
        self.created_servers = self._boot_servers(10)

    def tearDown(self):
        for server in self.created_servers:
            # TODO(msdubov): What's the proper way to clean up the cloud?
            server.delete()

    def _fake_metadata(self, amount):
        return {'foo_%d' % i: 'bar_%d' % i for i in xrange(amount)}

    def test_set_and_delete_meta(self):
        """Tests setting and then deleting 100 metadata records for each of
        the 10 prepared test servers.
        """
        fake_metadata = self._fake_metadata(100)
        for server in self.created_servers:
            self.servers.set_meta(server, fake_metadata)
        for server in self.created_servers:
            self.servers.delete_meta(server, fake_metadata.keys())
