# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2013: Mirantis Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from rally.benchmark.test_scenarios.nova import utils as nova_utils


class NovaServersTest(nova_utils.NovaTestCase):

    @classmethod
    def setUpClass(cls):
        super(NovaServersTest, cls).setUpClass()

    def setUp(self):
        # NOTE(msdubov): These additional 10 servers will be used
        #                for the update benchmark.
        self.created_servers = self._boot_servers(10, 'update_test_server')

    def tearDown(self):
        for server in self.created_servers:
            # TODO(msdubov): What's the proper way to clean up the cloud?
            server.delete()

    def test_boot_and_delete_sequentially(self):
        """Tests booting and then deleting 1000 instances sequentially."""
        servers = self._boot_servers(1000)
        for server in servers:
            server.delete()

    def test_boot_in_batches(self):
        """Tests booting 1000 instances in batches, booting 10 instances
        per request (resulting in 100 requests in total).
        """
        image, flavor = self._default_booting_configuration()
        for i in xrange(100):
            # TODO(msdubov): Completely unclear to me at this point how to boot
            #                10 instances simultaneously in a right way.
            #                All I could find in the source code for
            #                python-novaclient are the min_count & max_count
            #                parameters which are UNDOCUMENTED and seem to be
            #                in danger of conflicting with the quota
            # (see https://lists.launchpad.net/openstack/msg15721.html).
            self.servers.create('test_server_%d' % i, image, flavor,
                                min_count=10, max_count=10)

    def test_update(self):
        """Tests updating the information about servers, performing
        100 requests for each of the 10 prepared servers.
        """
        fake_names = ['fake_name_%d' % i for i in xrange(100)]
        for server in self.created_servers:
            for fake_name in fake_names:
                self.servers.update(server, fake_name)
