# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2013: Mirantis Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os
import ConfigParser
import fuel_health.manager
import fuel_health.test
from novaclient.client import Client

NOVA_API_VERSION = '2'


class NovaTestCase(fuel_health.test.TestCase):

    manager_class = fuel_health.manager.Manager

    @classmethod
    def setUpClass(cls):
        super(NovaTestCase, cls).setUpClass()

        cp = ConfigParser.RawConfigParser()
        cp.read(os.environ['OSTF_CONFIG'])
        username = cp.get('identity', 'admin_username')
        api_key = cp.get('identity', 'admin_password')
        project_id = cp.get('identity', 'admin_tenant_name')
        auth_url = cp.get('identity', 'uri')

        cls.nova_client = Client(username=username, api_key=api_key,
                                 project_id=project_id, auth_url=auth_url,
                                 version=NOVA_API_VERSION)

        cls.servers = cls.nova_client.servers.list()
        cls.flavors = cls.nova_client.flavors.list()
        cls.images = cls.nova_client.images.list()

    def _default_booting_configuration(self):
        """Setting up the default booting configuration
        to use in benchmarks.

        :returns: a pair of an image and a flavor to be used
                  in the default booting configuration
        """
        # TODO(msdubov): Is there any way to get a "default" image here?
        image = self.images[0]
        # TODO(msdubov): Is there any way to get a "default" flavor here?
        flavor = self.flavors[0]
        return image, flavor

    def _boot_servers(self, amount, name_prefix='test_server'):
        """Boots multiple servers in the cloud using the default
        booting configuration.

        :param amount: Number of servers to boot

        :returns: List of created server objects
        """
        image, flavor = self._default_booting_configuration()
        created_servers = []
        for i in xrange(amount):
            server = self.servers.create('%s_%d' % (name_prefix, i), image,
                                         flavor, return_raw=False)
            created_servers.append(server)
        return created_servers
